/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.panorama.model.DnsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StaticIpConnectionInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StaticIpConnectionInfo> {
    private static final SdkField<String> DEFAULT_GATEWAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultGateway").getter(StaticIpConnectionInfo.getter(StaticIpConnectionInfo::defaultGateway)).setter(StaticIpConnectionInfo.setter(Builder::defaultGateway)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultGateway").build()}).build();
    private static final SdkField<List<String>> DNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Dns").getter(StaticIpConnectionInfo.getter(StaticIpConnectionInfo::dns)).setter(StaticIpConnectionInfo.setter(Builder::dns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddress").getter(StaticIpConnectionInfo.getter(StaticIpConnectionInfo::ipAddress)).setter(StaticIpConnectionInfo.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()}).build();
    private static final SdkField<String> MASK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mask").getter(StaticIpConnectionInfo.getter(StaticIpConnectionInfo::mask)).setter(StaticIpConnectionInfo.setter(Builder::mask)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mask").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_GATEWAY_FIELD, DNS_FIELD, IP_ADDRESS_FIELD, MASK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StaticIpConnectionInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String defaultGateway;
    private final List<String> dns;
    private final String ipAddress;
    private final String mask;

    private StaticIpConnectionInfo(BuilderImpl builder) {
        this.defaultGateway = builder.defaultGateway;
        this.dns = builder.dns;
        this.ipAddress = builder.ipAddress;
        this.mask = builder.mask;
    }

    public final String defaultGateway() {
        return this.defaultGateway;
    }

    public final boolean hasDns() {
        return this.dns != null && !(this.dns instanceof SdkAutoConstructList);
    }

    public final List<String> dns() {
        return this.dns;
    }

    public final String ipAddress() {
        return this.ipAddress;
    }

    public final String mask() {
        return this.mask;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultGateway());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDns() ? this.dns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.mask());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StaticIpConnectionInfo)) {
            return false;
        }
        StaticIpConnectionInfo other = (StaticIpConnectionInfo)obj;
        return Objects.equals(this.defaultGateway(), other.defaultGateway()) && this.hasDns() == other.hasDns() && Objects.equals(this.dns(), other.dns()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.mask(), other.mask());
    }

    public final String toString() {
        return ToString.builder((String)"StaticIpConnectionInfo").add("DefaultGateway", (Object)this.defaultGateway()).add("Dns", this.hasDns() ? this.dns() : null).add("IpAddress", (Object)this.ipAddress()).add("Mask", (Object)this.mask()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultGateway": {
                return Optional.ofNullable(clazz.cast(this.defaultGateway()));
            }
            case "Dns": {
                return Optional.ofNullable(clazz.cast(this.dns()));
            }
            case "IpAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "Mask": {
                return Optional.ofNullable(clazz.cast(this.mask()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DefaultGateway", DEFAULT_GATEWAY_FIELD);
        map.put("Dns", DNS_FIELD);
        map.put("IpAddress", IP_ADDRESS_FIELD);
        map.put("Mask", MASK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StaticIpConnectionInfo, T> g) {
        return obj -> g.apply((StaticIpConnectionInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String defaultGateway;
        private List<String> dns = DefaultSdkAutoConstructList.getInstance();
        private String ipAddress;
        private String mask;

        private BuilderImpl() {
        }

        private BuilderImpl(StaticIpConnectionInfo model) {
            this.defaultGateway(model.defaultGateway);
            this.dns(model.dns);
            this.ipAddress(model.ipAddress);
            this.mask(model.mask);
        }

        public final String getDefaultGateway() {
            return this.defaultGateway;
        }

        public final void setDefaultGateway(String defaultGateway) {
            this.defaultGateway = defaultGateway;
        }

        @Override
        public final Builder defaultGateway(String defaultGateway) {
            this.defaultGateway = defaultGateway;
            return this;
        }

        public final Collection<String> getDns() {
            if (this.dns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dns;
        }

        public final void setDns(Collection<String> dns) {
            this.dns = DnsListCopier.copy(dns);
        }

        @Override
        public final Builder dns(Collection<String> dns) {
            this.dns = DnsListCopier.copy(dns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dns(String ... dns) {
            this.dns(Arrays.asList(dns));
            return this;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getMask() {
            return this.mask;
        }

        public final void setMask(String mask) {
            this.mask = mask;
        }

        @Override
        public final Builder mask(String mask) {
            this.mask = mask;
            return this;
        }

        public StaticIpConnectionInfo build() {
            return new StaticIpConnectionInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StaticIpConnectionInfo> {
        public Builder defaultGateway(String var1);

        public Builder dns(Collection<String> var1);

        public Builder dns(String ... var1);

        public Builder ipAddress(String var1);

        public Builder mask(String var1);
    }
}

