/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.panorama.model.NodeSignal;
import software.amazon.awssdk.services.panorama.model.NodeSignalListCopier;
import software.amazon.awssdk.services.panorama.model.PanoramaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SignalApplicationInstanceNodeInstancesRequest
extends PanoramaRequest
implements ToCopyableBuilder<Builder, SignalApplicationInstanceNodeInstancesRequest> {
    private static final SdkField<String> APPLICATION_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationInstanceId").getter(SignalApplicationInstanceNodeInstancesRequest.getter(SignalApplicationInstanceNodeInstancesRequest::applicationInstanceId)).setter(SignalApplicationInstanceNodeInstancesRequest.setter(Builder::applicationInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ApplicationInstanceId").build()}).build();
    private static final SdkField<List<NodeSignal>> NODE_SIGNALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NodeSignals").getter(SignalApplicationInstanceNodeInstancesRequest.getter(SignalApplicationInstanceNodeInstancesRequest::nodeSignals)).setter(SignalApplicationInstanceNodeInstancesRequest.setter(Builder::nodeSignals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeSignals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NodeSignal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_INSTANCE_ID_FIELD, NODE_SIGNALS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SignalApplicationInstanceNodeInstancesRequest.memberNameToFieldInitializer();
    private final String applicationInstanceId;
    private final List<NodeSignal> nodeSignals;

    private SignalApplicationInstanceNodeInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.applicationInstanceId = builder.applicationInstanceId;
        this.nodeSignals = builder.nodeSignals;
    }

    public final String applicationInstanceId() {
        return this.applicationInstanceId;
    }

    public final boolean hasNodeSignals() {
        return this.nodeSignals != null && !(this.nodeSignals instanceof SdkAutoConstructList);
    }

    public final List<NodeSignal> nodeSignals() {
        return this.nodeSignals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodeSignals() ? this.nodeSignals() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignalApplicationInstanceNodeInstancesRequest)) {
            return false;
        }
        SignalApplicationInstanceNodeInstancesRequest other = (SignalApplicationInstanceNodeInstancesRequest)((Object)obj);
        return Objects.equals(this.applicationInstanceId(), other.applicationInstanceId()) && this.hasNodeSignals() == other.hasNodeSignals() && Objects.equals(this.nodeSignals(), other.nodeSignals());
    }

    public final String toString() {
        return ToString.builder((String)"SignalApplicationInstanceNodeInstancesRequest").add("ApplicationInstanceId", (Object)this.applicationInstanceId()).add("NodeSignals", this.hasNodeSignals() ? this.nodeSignals() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationInstanceId": {
                return Optional.ofNullable(clazz.cast(this.applicationInstanceId()));
            }
            case "NodeSignals": {
                return Optional.ofNullable(clazz.cast(this.nodeSignals()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationInstanceId", APPLICATION_INSTANCE_ID_FIELD);
        map.put("NodeSignals", NODE_SIGNALS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SignalApplicationInstanceNodeInstancesRequest, T> g) {
        return obj -> g.apply((SignalApplicationInstanceNodeInstancesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PanoramaRequest.BuilderImpl
    implements Builder {
        private String applicationInstanceId;
        private List<NodeSignal> nodeSignals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SignalApplicationInstanceNodeInstancesRequest model) {
            super(model);
            this.applicationInstanceId(model.applicationInstanceId);
            this.nodeSignals(model.nodeSignals);
        }

        public final String getApplicationInstanceId() {
            return this.applicationInstanceId;
        }

        public final void setApplicationInstanceId(String applicationInstanceId) {
            this.applicationInstanceId = applicationInstanceId;
        }

        @Override
        public final Builder applicationInstanceId(String applicationInstanceId) {
            this.applicationInstanceId = applicationInstanceId;
            return this;
        }

        public final List<NodeSignal.Builder> getNodeSignals() {
            List<NodeSignal.Builder> result = NodeSignalListCopier.copyToBuilder(this.nodeSignals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodeSignals(Collection<NodeSignal.BuilderImpl> nodeSignals) {
            this.nodeSignals = NodeSignalListCopier.copyFromBuilder(nodeSignals);
        }

        @Override
        public final Builder nodeSignals(Collection<NodeSignal> nodeSignals) {
            this.nodeSignals = NodeSignalListCopier.copy(nodeSignals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeSignals(NodeSignal ... nodeSignals) {
            this.nodeSignals(Arrays.asList(nodeSignals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeSignals(Consumer<NodeSignal.Builder> ... nodeSignals) {
            this.nodeSignals(Stream.of(nodeSignals).map(c -> (NodeSignal)((NodeSignal.Builder)NodeSignal.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SignalApplicationInstanceNodeInstancesRequest build() {
            return new SignalApplicationInstanceNodeInstancesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PanoramaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SignalApplicationInstanceNodeInstancesRequest> {
        public Builder applicationInstanceId(String var1);

        public Builder nodeSignals(Collection<NodeSignal> var1);

        public Builder nodeSignals(NodeSignal ... var1);

        public Builder nodeSignals(Consumer<NodeSignal.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

