/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PackageObject
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PackageObject> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(PackageObject.getter(PackageObject::name)).setter(PackageObject.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> PACKAGE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageVersion").getter(PackageObject.getter(PackageObject::packageVersion)).setter(PackageObject.setter(Builder::packageVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageVersion").build()}).build();
    private static final SdkField<String> PATCH_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PatchVersion").getter(PackageObject.getter(PackageObject::patchVersion)).setter(PackageObject.setter(Builder::patchVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PACKAGE_VERSION_FIELD, PATCH_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PackageObject.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String packageVersion;
    private final String patchVersion;

    private PackageObject(BuilderImpl builder) {
        this.name = builder.name;
        this.packageVersion = builder.packageVersion;
        this.patchVersion = builder.patchVersion;
    }

    public final String name() {
        return this.name;
    }

    public final String packageVersion() {
        return this.packageVersion;
    }

    public final String patchVersion() {
        return this.patchVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.patchVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageObject)) {
            return false;
        }
        PackageObject other = (PackageObject)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.packageVersion(), other.packageVersion()) && Objects.equals(this.patchVersion(), other.patchVersion());
    }

    public final String toString() {
        return ToString.builder((String)"PackageObject").add("Name", (Object)this.name()).add("PackageVersion", (Object)this.packageVersion()).add("PatchVersion", (Object)this.patchVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "PackageVersion": {
                return Optional.ofNullable(clazz.cast(this.packageVersion()));
            }
            case "PatchVersion": {
                return Optional.ofNullable(clazz.cast(this.patchVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Name", NAME_FIELD);
        map.put("PackageVersion", PACKAGE_VERSION_FIELD);
        map.put("PatchVersion", PATCH_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PackageObject, T> g) {
        return obj -> g.apply((PackageObject)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String packageVersion;
        private String patchVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageObject model) {
            this.name(model.name);
            this.packageVersion(model.packageVersion);
            this.patchVersion(model.patchVersion);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPackageVersion() {
            return this.packageVersion;
        }

        public final void setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
        }

        @Override
        public final Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        public final String getPatchVersion() {
            return this.patchVersion;
        }

        public final void setPatchVersion(String patchVersion) {
            this.patchVersion = patchVersion;
        }

        @Override
        public final Builder patchVersion(String patchVersion) {
            this.patchVersion = patchVersion;
            return this;
        }

        public PackageObject build() {
            return new PackageObject(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PackageObject> {
        public Builder name(String var1);

        public Builder packageVersion(String var1);

        public Builder patchVersion(String var1);
    }
}

