/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.outposts.OutpostsAsyncClient;
import software.amazon.awssdk.services.outposts.internal.UserAgentUtils;
import software.amazon.awssdk.services.outposts.model.GetOutpostBillingInformationRequest;
import software.amazon.awssdk.services.outposts.model.GetOutpostBillingInformationResponse;
import software.amazon.awssdk.services.outposts.model.Subscription;

public class GetOutpostBillingInformationPublisher
implements SdkPublisher<GetOutpostBillingInformationResponse> {
    private final OutpostsAsyncClient client;
    private final GetOutpostBillingInformationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetOutpostBillingInformationPublisher(OutpostsAsyncClient client, GetOutpostBillingInformationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetOutpostBillingInformationPublisher(OutpostsAsyncClient client, GetOutpostBillingInformationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetOutpostBillingInformationResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetOutpostBillingInformationResponse> subscriber) {
        subscriber.onSubscribe((org.reactivestreams.Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Subscription> subscriptions() {
        Function<GetOutpostBillingInformationResponse, Iterator> getIterator = response -> {
            if (response != null && response.subscriptions() != null) {
                return response.subscriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetOutpostBillingInformationResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetOutpostBillingInformationResponseFetcher
    implements AsyncPageFetcher<GetOutpostBillingInformationResponse> {
        private GetOutpostBillingInformationResponseFetcher() {
        }

        public boolean hasNextPage(GetOutpostBillingInformationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetOutpostBillingInformationResponse> nextPage(GetOutpostBillingInformationResponse previousPage) {
            if (previousPage == null) {
                return GetOutpostBillingInformationPublisher.this.client.getOutpostBillingInformation(GetOutpostBillingInformationPublisher.this.firstRequest);
            }
            return GetOutpostBillingInformationPublisher.this.client.getOutpostBillingInformation((GetOutpostBillingInformationRequest)((Object)GetOutpostBillingInformationPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

