/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.outposts.model.FiberOpticCableType;
import software.amazon.awssdk.services.outposts.model.MaximumSupportedWeightLbs;
import software.amazon.awssdk.services.outposts.model.OpticalStandard;
import software.amazon.awssdk.services.outposts.model.OutpostsRequest;
import software.amazon.awssdk.services.outposts.model.PowerConnector;
import software.amazon.awssdk.services.outposts.model.PowerDrawKva;
import software.amazon.awssdk.services.outposts.model.PowerFeedDrop;
import software.amazon.awssdk.services.outposts.model.PowerPhase;
import software.amazon.awssdk.services.outposts.model.UplinkCount;
import software.amazon.awssdk.services.outposts.model.UplinkGbps;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSiteRackPhysicalPropertiesRequest
extends OutpostsRequest
implements ToCopyableBuilder<Builder, UpdateSiteRackPhysicalPropertiesRequest> {
    private static final SdkField<String> SITE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SiteId").getter(UpdateSiteRackPhysicalPropertiesRequest.getter(UpdateSiteRackPhysicalPropertiesRequest::siteId)).setter(UpdateSiteRackPhysicalPropertiesRequest.setter(Builder::siteId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("SiteId").build()}).build();
    private static final SdkField<String> POWER_DRAW_KVA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PowerDrawKva").getter(UpdateSiteRackPhysicalPropertiesRequest.getter(UpdateSiteRackPhysicalPropertiesRequest::powerDrawKvaAsString)).setter(UpdateSiteRackPhysicalPropertiesRequest.setter(Builder::powerDrawKva)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PowerDrawKva").build()}).build();
    private static final SdkField<String> POWER_PHASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PowerPhase").getter(UpdateSiteRackPhysicalPropertiesRequest.getter(UpdateSiteRackPhysicalPropertiesRequest::powerPhaseAsString)).setter(UpdateSiteRackPhysicalPropertiesRequest.setter(Builder::powerPhase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PowerPhase").build()}).build();
    private static final SdkField<String> POWER_CONNECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PowerConnector").getter(UpdateSiteRackPhysicalPropertiesRequest.getter(UpdateSiteRackPhysicalPropertiesRequest::powerConnectorAsString)).setter(UpdateSiteRackPhysicalPropertiesRequest.setter(Builder::powerConnector)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PowerConnector").build()}).build();
    private static final SdkField<String> POWER_FEED_DROP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PowerFeedDrop").getter(UpdateSiteRackPhysicalPropertiesRequest.getter(UpdateSiteRackPhysicalPropertiesRequest::powerFeedDropAsString)).setter(UpdateSiteRackPhysicalPropertiesRequest.setter(Builder::powerFeedDrop)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PowerFeedDrop").build()}).build();
    private static final SdkField<String> UPLINK_GBPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UplinkGbps").getter(UpdateSiteRackPhysicalPropertiesRequest.getter(UpdateSiteRackPhysicalPropertiesRequest::uplinkGbpsAsString)).setter(UpdateSiteRackPhysicalPropertiesRequest.setter(Builder::uplinkGbps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UplinkGbps").build()}).build();
    private static final SdkField<String> UPLINK_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UplinkCount").getter(UpdateSiteRackPhysicalPropertiesRequest.getter(UpdateSiteRackPhysicalPropertiesRequest::uplinkCountAsString)).setter(UpdateSiteRackPhysicalPropertiesRequest.setter(Builder::uplinkCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UplinkCount").build()}).build();
    private static final SdkField<String> FIBER_OPTIC_CABLE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FiberOpticCableType").getter(UpdateSiteRackPhysicalPropertiesRequest.getter(UpdateSiteRackPhysicalPropertiesRequest::fiberOpticCableTypeAsString)).setter(UpdateSiteRackPhysicalPropertiesRequest.setter(Builder::fiberOpticCableType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FiberOpticCableType").build()}).build();
    private static final SdkField<String> OPTICAL_STANDARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OpticalStandard").getter(UpdateSiteRackPhysicalPropertiesRequest.getter(UpdateSiteRackPhysicalPropertiesRequest::opticalStandardAsString)).setter(UpdateSiteRackPhysicalPropertiesRequest.setter(Builder::opticalStandard)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpticalStandard").build()}).build();
    private static final SdkField<String> MAXIMUM_SUPPORTED_WEIGHT_LBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaximumSupportedWeightLbs").getter(UpdateSiteRackPhysicalPropertiesRequest.getter(UpdateSiteRackPhysicalPropertiesRequest::maximumSupportedWeightLbsAsString)).setter(UpdateSiteRackPhysicalPropertiesRequest.setter(Builder::maximumSupportedWeightLbs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumSupportedWeightLbs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SITE_ID_FIELD, POWER_DRAW_KVA_FIELD, POWER_PHASE_FIELD, POWER_CONNECTOR_FIELD, POWER_FEED_DROP_FIELD, UPLINK_GBPS_FIELD, UPLINK_COUNT_FIELD, FIBER_OPTIC_CABLE_TYPE_FIELD, OPTICAL_STANDARD_FIELD, MAXIMUM_SUPPORTED_WEIGHT_LBS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateSiteRackPhysicalPropertiesRequest.memberNameToFieldInitializer();
    private final String siteId;
    private final String powerDrawKva;
    private final String powerPhase;
    private final String powerConnector;
    private final String powerFeedDrop;
    private final String uplinkGbps;
    private final String uplinkCount;
    private final String fiberOpticCableType;
    private final String opticalStandard;
    private final String maximumSupportedWeightLbs;

    private UpdateSiteRackPhysicalPropertiesRequest(BuilderImpl builder) {
        super(builder);
        this.siteId = builder.siteId;
        this.powerDrawKva = builder.powerDrawKva;
        this.powerPhase = builder.powerPhase;
        this.powerConnector = builder.powerConnector;
        this.powerFeedDrop = builder.powerFeedDrop;
        this.uplinkGbps = builder.uplinkGbps;
        this.uplinkCount = builder.uplinkCount;
        this.fiberOpticCableType = builder.fiberOpticCableType;
        this.opticalStandard = builder.opticalStandard;
        this.maximumSupportedWeightLbs = builder.maximumSupportedWeightLbs;
    }

    public final String siteId() {
        return this.siteId;
    }

    public final PowerDrawKva powerDrawKva() {
        return PowerDrawKva.fromValue(this.powerDrawKva);
    }

    public final String powerDrawKvaAsString() {
        return this.powerDrawKva;
    }

    public final PowerPhase powerPhase() {
        return PowerPhase.fromValue(this.powerPhase);
    }

    public final String powerPhaseAsString() {
        return this.powerPhase;
    }

    public final PowerConnector powerConnector() {
        return PowerConnector.fromValue(this.powerConnector);
    }

    public final String powerConnectorAsString() {
        return this.powerConnector;
    }

    public final PowerFeedDrop powerFeedDrop() {
        return PowerFeedDrop.fromValue(this.powerFeedDrop);
    }

    public final String powerFeedDropAsString() {
        return this.powerFeedDrop;
    }

    public final UplinkGbps uplinkGbps() {
        return UplinkGbps.fromValue(this.uplinkGbps);
    }

    public final String uplinkGbpsAsString() {
        return this.uplinkGbps;
    }

    public final UplinkCount uplinkCount() {
        return UplinkCount.fromValue(this.uplinkCount);
    }

    public final String uplinkCountAsString() {
        return this.uplinkCount;
    }

    public final FiberOpticCableType fiberOpticCableType() {
        return FiberOpticCableType.fromValue(this.fiberOpticCableType);
    }

    public final String fiberOpticCableTypeAsString() {
        return this.fiberOpticCableType;
    }

    public final OpticalStandard opticalStandard() {
        return OpticalStandard.fromValue(this.opticalStandard);
    }

    public final String opticalStandardAsString() {
        return this.opticalStandard;
    }

    public final MaximumSupportedWeightLbs maximumSupportedWeightLbs() {
        return MaximumSupportedWeightLbs.fromValue(this.maximumSupportedWeightLbs);
    }

    public final String maximumSupportedWeightLbsAsString() {
        return this.maximumSupportedWeightLbs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.siteId());
        hashCode = 31 * hashCode + Objects.hashCode(this.powerDrawKvaAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.powerPhaseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.powerConnectorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.powerFeedDropAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.uplinkGbpsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.uplinkCountAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fiberOpticCableTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.opticalStandardAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumSupportedWeightLbsAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSiteRackPhysicalPropertiesRequest)) {
            return false;
        }
        UpdateSiteRackPhysicalPropertiesRequest other = (UpdateSiteRackPhysicalPropertiesRequest)((Object)obj);
        return Objects.equals(this.siteId(), other.siteId()) && Objects.equals(this.powerDrawKvaAsString(), other.powerDrawKvaAsString()) && Objects.equals(this.powerPhaseAsString(), other.powerPhaseAsString()) && Objects.equals(this.powerConnectorAsString(), other.powerConnectorAsString()) && Objects.equals(this.powerFeedDropAsString(), other.powerFeedDropAsString()) && Objects.equals(this.uplinkGbpsAsString(), other.uplinkGbpsAsString()) && Objects.equals(this.uplinkCountAsString(), other.uplinkCountAsString()) && Objects.equals(this.fiberOpticCableTypeAsString(), other.fiberOpticCableTypeAsString()) && Objects.equals(this.opticalStandardAsString(), other.opticalStandardAsString()) && Objects.equals(this.maximumSupportedWeightLbsAsString(), other.maximumSupportedWeightLbsAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSiteRackPhysicalPropertiesRequest").add("SiteId", (Object)this.siteId()).add("PowerDrawKva", (Object)this.powerDrawKvaAsString()).add("PowerPhase", (Object)this.powerPhaseAsString()).add("PowerConnector", (Object)this.powerConnectorAsString()).add("PowerFeedDrop", (Object)this.powerFeedDropAsString()).add("UplinkGbps", (Object)this.uplinkGbpsAsString()).add("UplinkCount", (Object)this.uplinkCountAsString()).add("FiberOpticCableType", (Object)this.fiberOpticCableTypeAsString()).add("OpticalStandard", (Object)this.opticalStandardAsString()).add("MaximumSupportedWeightLbs", (Object)this.maximumSupportedWeightLbsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SiteId": {
                return Optional.ofNullable(clazz.cast(this.siteId()));
            }
            case "PowerDrawKva": {
                return Optional.ofNullable(clazz.cast(this.powerDrawKvaAsString()));
            }
            case "PowerPhase": {
                return Optional.ofNullable(clazz.cast(this.powerPhaseAsString()));
            }
            case "PowerConnector": {
                return Optional.ofNullable(clazz.cast(this.powerConnectorAsString()));
            }
            case "PowerFeedDrop": {
                return Optional.ofNullable(clazz.cast(this.powerFeedDropAsString()));
            }
            case "UplinkGbps": {
                return Optional.ofNullable(clazz.cast(this.uplinkGbpsAsString()));
            }
            case "UplinkCount": {
                return Optional.ofNullable(clazz.cast(this.uplinkCountAsString()));
            }
            case "FiberOpticCableType": {
                return Optional.ofNullable(clazz.cast(this.fiberOpticCableTypeAsString()));
            }
            case "OpticalStandard": {
                return Optional.ofNullable(clazz.cast(this.opticalStandardAsString()));
            }
            case "MaximumSupportedWeightLbs": {
                return Optional.ofNullable(clazz.cast(this.maximumSupportedWeightLbsAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("SiteId", SITE_ID_FIELD);
        map.put("PowerDrawKva", POWER_DRAW_KVA_FIELD);
        map.put("PowerPhase", POWER_PHASE_FIELD);
        map.put("PowerConnector", POWER_CONNECTOR_FIELD);
        map.put("PowerFeedDrop", POWER_FEED_DROP_FIELD);
        map.put("UplinkGbps", UPLINK_GBPS_FIELD);
        map.put("UplinkCount", UPLINK_COUNT_FIELD);
        map.put("FiberOpticCableType", FIBER_OPTIC_CABLE_TYPE_FIELD);
        map.put("OpticalStandard", OPTICAL_STANDARD_FIELD);
        map.put("MaximumSupportedWeightLbs", MAXIMUM_SUPPORTED_WEIGHT_LBS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSiteRackPhysicalPropertiesRequest, T> g) {
        return obj -> g.apply((UpdateSiteRackPhysicalPropertiesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OutpostsRequest.BuilderImpl
    implements Builder {
        private String siteId;
        private String powerDrawKva;
        private String powerPhase;
        private String powerConnector;
        private String powerFeedDrop;
        private String uplinkGbps;
        private String uplinkCount;
        private String fiberOpticCableType;
        private String opticalStandard;
        private String maximumSupportedWeightLbs;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSiteRackPhysicalPropertiesRequest model) {
            super(model);
            this.siteId(model.siteId);
            this.powerDrawKva(model.powerDrawKva);
            this.powerPhase(model.powerPhase);
            this.powerConnector(model.powerConnector);
            this.powerFeedDrop(model.powerFeedDrop);
            this.uplinkGbps(model.uplinkGbps);
            this.uplinkCount(model.uplinkCount);
            this.fiberOpticCableType(model.fiberOpticCableType);
            this.opticalStandard(model.opticalStandard);
            this.maximumSupportedWeightLbs(model.maximumSupportedWeightLbs);
        }

        public final String getSiteId() {
            return this.siteId;
        }

        public final void setSiteId(String siteId) {
            this.siteId = siteId;
        }

        @Override
        public final Builder siteId(String siteId) {
            this.siteId = siteId;
            return this;
        }

        public final String getPowerDrawKva() {
            return this.powerDrawKva;
        }

        public final void setPowerDrawKva(String powerDrawKva) {
            this.powerDrawKva = powerDrawKva;
        }

        @Override
        public final Builder powerDrawKva(String powerDrawKva) {
            this.powerDrawKva = powerDrawKva;
            return this;
        }

        @Override
        public final Builder powerDrawKva(PowerDrawKva powerDrawKva) {
            this.powerDrawKva(powerDrawKva == null ? null : powerDrawKva.toString());
            return this;
        }

        public final String getPowerPhase() {
            return this.powerPhase;
        }

        public final void setPowerPhase(String powerPhase) {
            this.powerPhase = powerPhase;
        }

        @Override
        public final Builder powerPhase(String powerPhase) {
            this.powerPhase = powerPhase;
            return this;
        }

        @Override
        public final Builder powerPhase(PowerPhase powerPhase) {
            this.powerPhase(powerPhase == null ? null : powerPhase.toString());
            return this;
        }

        public final String getPowerConnector() {
            return this.powerConnector;
        }

        public final void setPowerConnector(String powerConnector) {
            this.powerConnector = powerConnector;
        }

        @Override
        public final Builder powerConnector(String powerConnector) {
            this.powerConnector = powerConnector;
            return this;
        }

        @Override
        public final Builder powerConnector(PowerConnector powerConnector) {
            this.powerConnector(powerConnector == null ? null : powerConnector.toString());
            return this;
        }

        public final String getPowerFeedDrop() {
            return this.powerFeedDrop;
        }

        public final void setPowerFeedDrop(String powerFeedDrop) {
            this.powerFeedDrop = powerFeedDrop;
        }

        @Override
        public final Builder powerFeedDrop(String powerFeedDrop) {
            this.powerFeedDrop = powerFeedDrop;
            return this;
        }

        @Override
        public final Builder powerFeedDrop(PowerFeedDrop powerFeedDrop) {
            this.powerFeedDrop(powerFeedDrop == null ? null : powerFeedDrop.toString());
            return this;
        }

        public final String getUplinkGbps() {
            return this.uplinkGbps;
        }

        public final void setUplinkGbps(String uplinkGbps) {
            this.uplinkGbps = uplinkGbps;
        }

        @Override
        public final Builder uplinkGbps(String uplinkGbps) {
            this.uplinkGbps = uplinkGbps;
            return this;
        }

        @Override
        public final Builder uplinkGbps(UplinkGbps uplinkGbps) {
            this.uplinkGbps(uplinkGbps == null ? null : uplinkGbps.toString());
            return this;
        }

        public final String getUplinkCount() {
            return this.uplinkCount;
        }

        public final void setUplinkCount(String uplinkCount) {
            this.uplinkCount = uplinkCount;
        }

        @Override
        public final Builder uplinkCount(String uplinkCount) {
            this.uplinkCount = uplinkCount;
            return this;
        }

        @Override
        public final Builder uplinkCount(UplinkCount uplinkCount) {
            this.uplinkCount(uplinkCount == null ? null : uplinkCount.toString());
            return this;
        }

        public final String getFiberOpticCableType() {
            return this.fiberOpticCableType;
        }

        public final void setFiberOpticCableType(String fiberOpticCableType) {
            this.fiberOpticCableType = fiberOpticCableType;
        }

        @Override
        public final Builder fiberOpticCableType(String fiberOpticCableType) {
            this.fiberOpticCableType = fiberOpticCableType;
            return this;
        }

        @Override
        public final Builder fiberOpticCableType(FiberOpticCableType fiberOpticCableType) {
            this.fiberOpticCableType(fiberOpticCableType == null ? null : fiberOpticCableType.toString());
            return this;
        }

        public final String getOpticalStandard() {
            return this.opticalStandard;
        }

        public final void setOpticalStandard(String opticalStandard) {
            this.opticalStandard = opticalStandard;
        }

        @Override
        public final Builder opticalStandard(String opticalStandard) {
            this.opticalStandard = opticalStandard;
            return this;
        }

        @Override
        public final Builder opticalStandard(OpticalStandard opticalStandard) {
            this.opticalStandard(opticalStandard == null ? null : opticalStandard.toString());
            return this;
        }

        public final String getMaximumSupportedWeightLbs() {
            return this.maximumSupportedWeightLbs;
        }

        public final void setMaximumSupportedWeightLbs(String maximumSupportedWeightLbs) {
            this.maximumSupportedWeightLbs = maximumSupportedWeightLbs;
        }

        @Override
        public final Builder maximumSupportedWeightLbs(String maximumSupportedWeightLbs) {
            this.maximumSupportedWeightLbs = maximumSupportedWeightLbs;
            return this;
        }

        @Override
        public final Builder maximumSupportedWeightLbs(MaximumSupportedWeightLbs maximumSupportedWeightLbs) {
            this.maximumSupportedWeightLbs(maximumSupportedWeightLbs == null ? null : maximumSupportedWeightLbs.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSiteRackPhysicalPropertiesRequest build() {
            return new UpdateSiteRackPhysicalPropertiesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OutpostsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSiteRackPhysicalPropertiesRequest> {
        public Builder siteId(String var1);

        public Builder powerDrawKva(String var1);

        public Builder powerDrawKva(PowerDrawKva var1);

        public Builder powerPhase(String var1);

        public Builder powerPhase(PowerPhase var1);

        public Builder powerConnector(String var1);

        public Builder powerConnector(PowerConnector var1);

        public Builder powerFeedDrop(String var1);

        public Builder powerFeedDrop(PowerFeedDrop var1);

        public Builder uplinkGbps(String var1);

        public Builder uplinkGbps(UplinkGbps var1);

        public Builder uplinkCount(String var1);

        public Builder uplinkCount(UplinkCount var1);

        public Builder fiberOpticCableType(String var1);

        public Builder fiberOpticCableType(FiberOpticCableType var1);

        public Builder opticalStandard(String var1);

        public Builder opticalStandard(OpticalStandard var1);

        public Builder maximumSupportedWeightLbs(String var1);

        public Builder maximumSupportedWeightLbs(MaximumSupportedWeightLbs var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

