/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BlockingResourceType {
    EC2_INSTANCE("EC2_INSTANCE"),
    OUTPOST_RAM_SHARE("OUTPOST_RAM_SHARE"),
    LGW_ROUTING_DOMAIN("LGW_ROUTING_DOMAIN"),
    LGW_ROUTE_TABLE("LGW_ROUTE_TABLE"),
    LGW_VIRTUAL_INTERFACE_GROUP("LGW_VIRTUAL_INTERFACE_GROUP"),
    OUTPOST_ORDER_CANCELLABLE("OUTPOST_ORDER_CANCELLABLE"),
    OUTPOST_ORDER_INTERVENTION_REQUIRED("OUTPOST_ORDER_INTERVENTION_REQUIRED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BlockingResourceType> VALUE_MAP;
    private final String value;

    private BlockingResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BlockingResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BlockingResourceType> knownValues() {
        EnumSet<BlockingResourceType> knownValues = EnumSet.allOf(BlockingResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BlockingResourceType.class, BlockingResourceType::toString);
    }
}

