/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SupportedHardwareType {
    RACK("RACK"),
    SERVER("SERVER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SupportedHardwareType> VALUE_MAP;
    private final String value;

    private SupportedHardwareType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SupportedHardwareType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SupportedHardwareType> knownValues() {
        EnumSet<SupportedHardwareType> knownValues = EnumSet.allOf(SupportedHardwareType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SupportedHardwareType.class, SupportedHardwareType::toString);
    }
}

