/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ShipmentCarrier {
    DHL("DHL"),
    DBS("DBS"),
    FEDEX("FEDEX"),
    UPS("UPS"),
    EXPEDITORS("EXPEDITORS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ShipmentCarrier> VALUE_MAP;
    private final String value;

    private ShipmentCarrier(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ShipmentCarrier fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ShipmentCarrier> knownValues() {
        EnumSet<ShipmentCarrier> knownValues = EnumSet.allOf(ShipmentCarrier.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ShipmentCarrier.class, ShipmentCarrier::toString);
    }
}

