/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.outposts.OutpostsClient;
import software.amazon.awssdk.services.outposts.internal.UserAgentUtils;
import software.amazon.awssdk.services.outposts.model.AssetInstance;
import software.amazon.awssdk.services.outposts.model.ListAssetInstancesRequest;
import software.amazon.awssdk.services.outposts.model.ListAssetInstancesResponse;

public class ListAssetInstancesIterable
implements SdkIterable<ListAssetInstancesResponse> {
    private final OutpostsClient client;
    private final ListAssetInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAssetInstancesIterable(OutpostsClient client, ListAssetInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAssetInstancesResponseFetcher();
    }

    public Iterator<ListAssetInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AssetInstance> assetInstances() {
        Function<ListAssetInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.assetInstances() != null) {
                return response.assetInstances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAssetInstancesResponseFetcher
    implements SyncPageFetcher<ListAssetInstancesResponse> {
        private ListAssetInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListAssetInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAssetInstancesResponse nextPage(ListAssetInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListAssetInstancesIterable.this.client.listAssetInstances(ListAssetInstancesIterable.this.firstRequest);
            }
            return ListAssetInstancesIterable.this.client.listAssetInstances((ListAssetInstancesRequest)((Object)ListAssetInstancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

