/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.outposts.model.InstanceTypeItem;
import software.amazon.awssdk.services.outposts.model.InstanceTypeListDefinitionCopier;
import software.amazon.awssdk.services.outposts.model.OutpostsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetOutpostInstanceTypesResponse
extends OutpostsResponse
implements ToCopyableBuilder<Builder, GetOutpostInstanceTypesResponse> {
    private static final SdkField<List<InstanceTypeItem>> INSTANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceTypes").getter(GetOutpostInstanceTypesResponse.getter(GetOutpostInstanceTypesResponse::instanceTypes)).setter(GetOutpostInstanceTypesResponse.setter(Builder::instanceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceTypeItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetOutpostInstanceTypesResponse.getter(GetOutpostInstanceTypesResponse::nextToken)).setter(GetOutpostInstanceTypesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> OUTPOST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostId").getter(GetOutpostInstanceTypesResponse.getter(GetOutpostInstanceTypesResponse::outpostId)).setter(GetOutpostInstanceTypesResponse.setter(Builder::outpostId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostId").build()}).build();
    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostArn").getter(GetOutpostInstanceTypesResponse.getter(GetOutpostInstanceTypesResponse::outpostArn)).setter(GetOutpostInstanceTypesResponse.setter(Builder::outpostArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPES_FIELD, NEXT_TOKEN_FIELD, OUTPOST_ID_FIELD, OUTPOST_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetOutpostInstanceTypesResponse.memberNameToFieldInitializer();
    private final List<InstanceTypeItem> instanceTypes;
    private final String nextToken;
    private final String outpostId;
    private final String outpostArn;

    private GetOutpostInstanceTypesResponse(BuilderImpl builder) {
        super(builder);
        this.instanceTypes = builder.instanceTypes;
        this.nextToken = builder.nextToken;
        this.outpostId = builder.outpostId;
        this.outpostArn = builder.outpostArn;
    }

    public final boolean hasInstanceTypes() {
        return this.instanceTypes != null && !(this.instanceTypes instanceof SdkAutoConstructList);
    }

    public final List<InstanceTypeItem> instanceTypes() {
        return this.instanceTypes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String outpostId() {
        return this.outpostId;
    }

    public final String outpostArn() {
        return this.outpostArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceTypes() ? this.instanceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostId());
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOutpostInstanceTypesResponse)) {
            return false;
        }
        GetOutpostInstanceTypesResponse other = (GetOutpostInstanceTypesResponse)((Object)obj);
        return this.hasInstanceTypes() == other.hasInstanceTypes() && Objects.equals(this.instanceTypes(), other.instanceTypes()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.outpostId(), other.outpostId()) && Objects.equals(this.outpostArn(), other.outpostArn());
    }

    public final String toString() {
        return ToString.builder((String)"GetOutpostInstanceTypesResponse").add("InstanceTypes", this.hasInstanceTypes() ? this.instanceTypes() : null).add("NextToken", (Object)this.nextToken()).add("OutpostId", (Object)this.outpostId()).add("OutpostArn", (Object)this.outpostArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceTypes": {
                return Optional.ofNullable(clazz.cast(this.instanceTypes()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "OutpostId": {
                return Optional.ofNullable(clazz.cast(this.outpostId()));
            }
            case "OutpostArn": {
                return Optional.ofNullable(clazz.cast(this.outpostArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceTypes", INSTANCE_TYPES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("OutpostId", OUTPOST_ID_FIELD);
        map.put("OutpostArn", OUTPOST_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOutpostInstanceTypesResponse, T> g) {
        return obj -> g.apply((GetOutpostInstanceTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OutpostsResponse.BuilderImpl
    implements Builder {
        private List<InstanceTypeItem> instanceTypes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String outpostId;
        private String outpostArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOutpostInstanceTypesResponse model) {
            super(model);
            this.instanceTypes(model.instanceTypes);
            this.nextToken(model.nextToken);
            this.outpostId(model.outpostId);
            this.outpostArn(model.outpostArn);
        }

        public final List<InstanceTypeItem.Builder> getInstanceTypes() {
            List<InstanceTypeItem.Builder> result = InstanceTypeListDefinitionCopier.copyToBuilder(this.instanceTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceTypes(Collection<InstanceTypeItem.BuilderImpl> instanceTypes) {
            this.instanceTypes = InstanceTypeListDefinitionCopier.copyFromBuilder(instanceTypes);
        }

        @Override
        public final Builder instanceTypes(Collection<InstanceTypeItem> instanceTypes) {
            this.instanceTypes = InstanceTypeListDefinitionCopier.copy(instanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(InstanceTypeItem ... instanceTypes) {
            this.instanceTypes(Arrays.asList(instanceTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(Consumer<InstanceTypeItem.Builder> ... instanceTypes) {
            this.instanceTypes(Stream.of(instanceTypes).map(c -> (InstanceTypeItem)((InstanceTypeItem.Builder)InstanceTypeItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getOutpostId() {
            return this.outpostId;
        }

        public final void setOutpostId(String outpostId) {
            this.outpostId = outpostId;
        }

        @Override
        public final Builder outpostId(String outpostId) {
            this.outpostId = outpostId;
            return this;
        }

        public final String getOutpostArn() {
            return this.outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        @Override
        public GetOutpostInstanceTypesResponse build() {
            return new GetOutpostInstanceTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OutpostsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetOutpostInstanceTypesResponse> {
        public Builder instanceTypes(Collection<InstanceTypeItem> var1);

        public Builder instanceTypes(InstanceTypeItem ... var1);

        public Builder instanceTypes(Consumer<InstanceTypeItem.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder outpostId(String var1);

        public Builder outpostArn(String var1);
    }
}

