/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.outposts.model.AWSServiceName;
import software.amazon.awssdk.services.outposts.model.AWSServiceNameListCopier;
import software.amazon.awssdk.services.outposts.model.AccountIdListCopier;
import software.amazon.awssdk.services.outposts.model.InstanceIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstancesToExclude
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstancesToExclude> {
    private static final SdkField<List<String>> INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Instances").getter(InstancesToExclude.getter(InstancesToExclude::instances)).setter(InstancesToExclude.setter(Builder::instances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccountIds").getter(InstancesToExclude.getter(InstancesToExclude::accountIds)).setter(InstancesToExclude.setter(Builder::accountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Services").getter(InstancesToExclude.getter(InstancesToExclude::servicesAsStrings)).setter(InstancesToExclude.setter(Builder::servicesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Services").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCES_FIELD, ACCOUNT_IDS_FIELD, SERVICES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstancesToExclude.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> instances;
    private final List<String> accountIds;
    private final List<String> services;

    private InstancesToExclude(BuilderImpl builder) {
        this.instances = builder.instances;
        this.accountIds = builder.accountIds;
        this.services = builder.services;
    }

    public final boolean hasInstances() {
        return this.instances != null && !(this.instances instanceof SdkAutoConstructList);
    }

    public final List<String> instances() {
        return this.instances;
    }

    public final boolean hasAccountIds() {
        return this.accountIds != null && !(this.accountIds instanceof SdkAutoConstructList);
    }

    public final List<String> accountIds() {
        return this.accountIds;
    }

    public final List<AWSServiceName> services() {
        return AWSServiceNameListCopier.copyStringToEnum(this.services);
    }

    public final boolean hasServices() {
        return this.services != null && !(this.services instanceof SdkAutoConstructList);
    }

    public final List<String> servicesAsStrings() {
        return this.services;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstances() ? this.instances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountIds() ? this.accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServices() ? this.servicesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstancesToExclude)) {
            return false;
        }
        InstancesToExclude other = (InstancesToExclude)obj;
        return this.hasInstances() == other.hasInstances() && Objects.equals(this.instances(), other.instances()) && this.hasAccountIds() == other.hasAccountIds() && Objects.equals(this.accountIds(), other.accountIds()) && this.hasServices() == other.hasServices() && Objects.equals(this.servicesAsStrings(), other.servicesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"InstancesToExclude").add("Instances", this.hasInstances() ? this.instances() : null).add("AccountIds", this.hasAccountIds() ? this.accountIds() : null).add("Services", this.hasServices() ? this.servicesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Instances": {
                return Optional.ofNullable(clazz.cast(this.instances()));
            }
            case "AccountIds": {
                return Optional.ofNullable(clazz.cast(this.accountIds()));
            }
            case "Services": {
                return Optional.ofNullable(clazz.cast(this.servicesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("Instances", INSTANCES_FIELD);
        map.put("AccountIds", ACCOUNT_IDS_FIELD);
        map.put("Services", SERVICES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstancesToExclude, T> g) {
        return obj -> g.apply((InstancesToExclude)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> instances = DefaultSdkAutoConstructList.getInstance();
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> services = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstancesToExclude model) {
            this.instances(model.instances);
            this.accountIds(model.accountIds);
            this.servicesWithStrings(model.services);
        }

        public final Collection<String> getInstances() {
            if (this.instances instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instances;
        }

        public final void setInstances(Collection<String> instances) {
            this.instances = InstanceIdListCopier.copy(instances);
        }

        @Override
        public final Builder instances(Collection<String> instances) {
            this.instances = InstanceIdListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(String ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        public final Collection<String> getAccountIds() {
            if (this.accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdListCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String ... accountIds) {
            this.accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final Collection<String> getServices() {
            if (this.services instanceof SdkAutoConstructList) {
                return null;
            }
            return this.services;
        }

        public final void setServices(Collection<String> services) {
            this.services = AWSServiceNameListCopier.copy(services);
        }

        @Override
        public final Builder servicesWithStrings(Collection<String> services) {
            this.services = AWSServiceNameListCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder servicesWithStrings(String ... services) {
            this.servicesWithStrings(Arrays.asList(services));
            return this;
        }

        @Override
        public final Builder services(Collection<AWSServiceName> services) {
            this.services = AWSServiceNameListCopier.copyEnumToString(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(AWSServiceName ... services) {
            this.services(Arrays.asList(services));
            return this;
        }

        public InstancesToExclude build() {
            return new InstancesToExclude(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstancesToExclude> {
        public Builder instances(Collection<String> var1);

        public Builder instances(String ... var1);

        public Builder accountIds(Collection<String> var1);

        public Builder accountIds(String ... var1);

        public Builder servicesWithStrings(Collection<String> var1);

        public Builder servicesWithStrings(String ... var1);

        public Builder services(Collection<AWSServiceName> var1);

        public Builder services(AWSServiceName ... var1);
    }
}

