/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CatalogItemStatus {
    AVAILABLE("AVAILABLE"),
    DISCONTINUED("DISCONTINUED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CatalogItemStatus> VALUE_MAP;
    private final String value;

    private CatalogItemStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CatalogItemStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CatalogItemStatus> knownValues() {
        EnumSet<CatalogItemStatus> knownValues = EnumSet.allOf(CatalogItemStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CatalogItemStatus.class, CatalogItemStatus::toString);
    }
}

