/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.osis.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.osis.OsisClient;
import software.amazon.awssdk.services.osis.internal.UserAgentUtils;
import software.amazon.awssdk.services.osis.model.ListPipelineEndpointsRequest;
import software.amazon.awssdk.services.osis.model.ListPipelineEndpointsResponse;
import software.amazon.awssdk.services.osis.model.PipelineEndpoint;

public class ListPipelineEndpointsIterable
implements SdkIterable<ListPipelineEndpointsResponse> {
    private final OsisClient client;
    private final ListPipelineEndpointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPipelineEndpointsIterable(OsisClient client, ListPipelineEndpointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPipelineEndpointsResponseFetcher();
    }

    public Iterator<ListPipelineEndpointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PipelineEndpoint> pipelineEndpoints() {
        Function<ListPipelineEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.pipelineEndpoints() != null) {
                return response.pipelineEndpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPipelineEndpointsResponseFetcher
    implements SyncPageFetcher<ListPipelineEndpointsResponse> {
        private ListPipelineEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListPipelineEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPipelineEndpointsResponse nextPage(ListPipelineEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListPipelineEndpointsIterable.this.client.listPipelineEndpoints(ListPipelineEndpointsIterable.this.firstRequest);
            }
            return ListPipelineEndpointsIterable.this.client.listPipelineEndpoints((ListPipelineEndpointsRequest)((Object)ListPipelineEndpointsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

