/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.osis;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.osis.DefaultOsisAsyncClientBuilder;
import software.amazon.awssdk.services.osis.OsisAsyncClientBuilder;
import software.amazon.awssdk.services.osis.OsisServiceClientConfiguration;
import software.amazon.awssdk.services.osis.model.CreatePipelineRequest;
import software.amazon.awssdk.services.osis.model.CreatePipelineResponse;
import software.amazon.awssdk.services.osis.model.DeletePipelineRequest;
import software.amazon.awssdk.services.osis.model.DeletePipelineResponse;
import software.amazon.awssdk.services.osis.model.GetPipelineBlueprintRequest;
import software.amazon.awssdk.services.osis.model.GetPipelineBlueprintResponse;
import software.amazon.awssdk.services.osis.model.GetPipelineChangeProgressRequest;
import software.amazon.awssdk.services.osis.model.GetPipelineChangeProgressResponse;
import software.amazon.awssdk.services.osis.model.GetPipelineRequest;
import software.amazon.awssdk.services.osis.model.GetPipelineResponse;
import software.amazon.awssdk.services.osis.model.ListPipelineBlueprintsRequest;
import software.amazon.awssdk.services.osis.model.ListPipelineBlueprintsResponse;
import software.amazon.awssdk.services.osis.model.ListPipelinesRequest;
import software.amazon.awssdk.services.osis.model.ListPipelinesResponse;
import software.amazon.awssdk.services.osis.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.osis.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.osis.model.StartPipelineRequest;
import software.amazon.awssdk.services.osis.model.StartPipelineResponse;
import software.amazon.awssdk.services.osis.model.StopPipelineRequest;
import software.amazon.awssdk.services.osis.model.StopPipelineResponse;
import software.amazon.awssdk.services.osis.model.TagResourceRequest;
import software.amazon.awssdk.services.osis.model.TagResourceResponse;
import software.amazon.awssdk.services.osis.model.UntagResourceRequest;
import software.amazon.awssdk.services.osis.model.UntagResourceResponse;
import software.amazon.awssdk.services.osis.model.UpdatePipelineRequest;
import software.amazon.awssdk.services.osis.model.UpdatePipelineResponse;
import software.amazon.awssdk.services.osis.model.ValidatePipelineRequest;
import software.amazon.awssdk.services.osis.model.ValidatePipelineResponse;
import software.amazon.awssdk.services.osis.paginators.ListPipelinesPublisher;

@SdkPublicApi
@ThreadSafe
public interface OsisAsyncClient
extends AwsClient {
    public static final String SERVICE_NAME = "osis";
    public static final String SERVICE_METADATA_ID = "osis";

    default public CompletableFuture<CreatePipelineResponse> createPipeline(CreatePipelineRequest createPipelineRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CreatePipelineResponse> createPipeline(Consumer<CreatePipelineRequest.Builder> createPipelineRequest) {
        return this.createPipeline((CreatePipelineRequest)((Object)((CreatePipelineRequest.Builder)CreatePipelineRequest.builder().applyMutation(createPipelineRequest)).build()));
    }

    default public CompletableFuture<DeletePipelineResponse> deletePipeline(DeletePipelineRequest deletePipelineRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeletePipelineResponse> deletePipeline(Consumer<DeletePipelineRequest.Builder> deletePipelineRequest) {
        return this.deletePipeline((DeletePipelineRequest)((Object)((DeletePipelineRequest.Builder)DeletePipelineRequest.builder().applyMutation(deletePipelineRequest)).build()));
    }

    default public CompletableFuture<GetPipelineResponse> getPipeline(GetPipelineRequest getPipelineRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetPipelineResponse> getPipeline(Consumer<GetPipelineRequest.Builder> getPipelineRequest) {
        return this.getPipeline((GetPipelineRequest)((Object)((GetPipelineRequest.Builder)GetPipelineRequest.builder().applyMutation(getPipelineRequest)).build()));
    }

    default public CompletableFuture<GetPipelineBlueprintResponse> getPipelineBlueprint(GetPipelineBlueprintRequest getPipelineBlueprintRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetPipelineBlueprintResponse> getPipelineBlueprint(Consumer<GetPipelineBlueprintRequest.Builder> getPipelineBlueprintRequest) {
        return this.getPipelineBlueprint((GetPipelineBlueprintRequest)((Object)((GetPipelineBlueprintRequest.Builder)GetPipelineBlueprintRequest.builder().applyMutation(getPipelineBlueprintRequest)).build()));
    }

    default public CompletableFuture<GetPipelineChangeProgressResponse> getPipelineChangeProgress(GetPipelineChangeProgressRequest getPipelineChangeProgressRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetPipelineChangeProgressResponse> getPipelineChangeProgress(Consumer<GetPipelineChangeProgressRequest.Builder> getPipelineChangeProgressRequest) {
        return this.getPipelineChangeProgress((GetPipelineChangeProgressRequest)((Object)((GetPipelineChangeProgressRequest.Builder)GetPipelineChangeProgressRequest.builder().applyMutation(getPipelineChangeProgressRequest)).build()));
    }

    default public CompletableFuture<ListPipelineBlueprintsResponse> listPipelineBlueprints(ListPipelineBlueprintsRequest listPipelineBlueprintsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListPipelineBlueprintsResponse> listPipelineBlueprints(Consumer<ListPipelineBlueprintsRequest.Builder> listPipelineBlueprintsRequest) {
        return this.listPipelineBlueprints((ListPipelineBlueprintsRequest)((Object)((ListPipelineBlueprintsRequest.Builder)ListPipelineBlueprintsRequest.builder().applyMutation(listPipelineBlueprintsRequest)).build()));
    }

    default public CompletableFuture<ListPipelinesResponse> listPipelines(ListPipelinesRequest listPipelinesRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListPipelinesResponse> listPipelines(Consumer<ListPipelinesRequest.Builder> listPipelinesRequest) {
        return this.listPipelines((ListPipelinesRequest)((Object)((ListPipelinesRequest.Builder)ListPipelinesRequest.builder().applyMutation(listPipelinesRequest)).build()));
    }

    default public ListPipelinesPublisher listPipelinesPaginator(ListPipelinesRequest listPipelinesRequest) {
        return new ListPipelinesPublisher(this, listPipelinesRequest);
    }

    default public ListPipelinesPublisher listPipelinesPaginator(Consumer<ListPipelinesRequest.Builder> listPipelinesRequest) {
        return this.listPipelinesPaginator((ListPipelinesRequest)((Object)((ListPipelinesRequest.Builder)ListPipelinesRequest.builder().applyMutation(listPipelinesRequest)).build()));
    }

    default public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public CompletableFuture<StartPipelineResponse> startPipeline(StartPipelineRequest startPipelineRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<StartPipelineResponse> startPipeline(Consumer<StartPipelineRequest.Builder> startPipelineRequest) {
        return this.startPipeline((StartPipelineRequest)((Object)((StartPipelineRequest.Builder)StartPipelineRequest.builder().applyMutation(startPipelineRequest)).build()));
    }

    default public CompletableFuture<StopPipelineResponse> stopPipeline(StopPipelineRequest stopPipelineRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<StopPipelineResponse> stopPipeline(Consumer<StopPipelineRequest.Builder> stopPipelineRequest) {
        return this.stopPipeline((StopPipelineRequest)((Object)((StopPipelineRequest.Builder)StopPipelineRequest.builder().applyMutation(stopPipelineRequest)).build()));
    }

    default public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public CompletableFuture<UpdatePipelineResponse> updatePipeline(UpdatePipelineRequest updatePipelineRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UpdatePipelineResponse> updatePipeline(Consumer<UpdatePipelineRequest.Builder> updatePipelineRequest) {
        return this.updatePipeline((UpdatePipelineRequest)((Object)((UpdatePipelineRequest.Builder)UpdatePipelineRequest.builder().applyMutation(updatePipelineRequest)).build()));
    }

    default public CompletableFuture<ValidatePipelineResponse> validatePipeline(ValidatePipelineRequest validatePipelineRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ValidatePipelineResponse> validatePipeline(Consumer<ValidatePipelineRequest.Builder> validatePipelineRequest) {
        return this.validatePipeline((ValidatePipelineRequest)((Object)((ValidatePipelineRequest.Builder)ValidatePipelineRequest.builder().applyMutation(validatePipelineRequest)).build()));
    }

    default public OsisServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    public static OsisAsyncClient create() {
        return (OsisAsyncClient)OsisAsyncClient.builder().build();
    }

    public static OsisAsyncClientBuilder builder() {
        return new DefaultOsisAsyncClientBuilder();
    }
}

