/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.osis.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.osis.OsisAsyncClient;
import software.amazon.awssdk.services.osis.internal.UserAgentUtils;
import software.amazon.awssdk.services.osis.model.ListPipelinesRequest;
import software.amazon.awssdk.services.osis.model.ListPipelinesResponse;

public class ListPipelinesPublisher
implements SdkPublisher<ListPipelinesResponse> {
    private final OsisAsyncClient client;
    private final ListPipelinesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPipelinesPublisher(OsisAsyncClient client, ListPipelinesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPipelinesPublisher(OsisAsyncClient client, ListPipelinesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPipelinesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPipelinesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListPipelinesResponseFetcher
    implements AsyncPageFetcher<ListPipelinesResponse> {
        private ListPipelinesResponseFetcher() {
        }

        public boolean hasNextPage(ListPipelinesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPipelinesResponse> nextPage(ListPipelinesResponse previousPage) {
            if (previousPage == null) {
                return ListPipelinesPublisher.this.client.listPipelines(ListPipelinesPublisher.this.firstRequest);
            }
            return ListPipelinesPublisher.this.client.listPipelines((ListPipelinesRequest)((Object)ListPipelinesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

