/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.organizations.model.ResourcePolicySummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourcePolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourcePolicy> {
    private static final SdkField<ResourcePolicySummary> RESOURCE_POLICY_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourcePolicySummary").getter(ResourcePolicy.getter(ResourcePolicy::resourcePolicySummary)).setter(ResourcePolicy.setter(Builder::resourcePolicySummary)).constructor(ResourcePolicySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcePolicySummary").build()}).build();
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Content").getter(ResourcePolicy.getter(ResourcePolicy::content)).setter(ResourcePolicy.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_POLICY_SUMMARY_FIELD, CONTENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourcePolicy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ResourcePolicySummary resourcePolicySummary;
    private final String content;

    private ResourcePolicy(BuilderImpl builder) {
        this.resourcePolicySummary = builder.resourcePolicySummary;
        this.content = builder.content;
    }

    public final ResourcePolicySummary resourcePolicySummary() {
        return this.resourcePolicySummary;
    }

    public final String content() {
        return this.content;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcePolicySummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcePolicy)) {
            return false;
        }
        ResourcePolicy other = (ResourcePolicy)obj;
        return Objects.equals(this.resourcePolicySummary(), other.resourcePolicySummary()) && Objects.equals(this.content(), other.content());
    }

    public final String toString() {
        return ToString.builder((String)"ResourcePolicy").add("ResourcePolicySummary", (Object)this.resourcePolicySummary()).add("Content", (Object)this.content()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourcePolicySummary": {
                return Optional.ofNullable(clazz.cast(this.resourcePolicySummary()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourcePolicySummary", RESOURCE_POLICY_SUMMARY_FIELD);
        map.put("Content", CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourcePolicy, T> g) {
        return obj -> g.apply((ResourcePolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ResourcePolicySummary resourcePolicySummary;
        private String content;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourcePolicy model) {
            this.resourcePolicySummary(model.resourcePolicySummary);
            this.content(model.content);
        }

        public final ResourcePolicySummary.Builder getResourcePolicySummary() {
            return this.resourcePolicySummary != null ? this.resourcePolicySummary.toBuilder() : null;
        }

        public final void setResourcePolicySummary(ResourcePolicySummary.BuilderImpl resourcePolicySummary) {
            this.resourcePolicySummary = resourcePolicySummary != null ? resourcePolicySummary.build() : null;
        }

        @Override
        public final Builder resourcePolicySummary(ResourcePolicySummary resourcePolicySummary) {
            this.resourcePolicySummary = resourcePolicySummary;
            return this;
        }

        public final String getContent() {
            return this.content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public ResourcePolicy build() {
            return new ResourcePolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourcePolicy> {
        public Builder resourcePolicySummary(ResourcePolicySummary var1);

        default public Builder resourcePolicySummary(Consumer<ResourcePolicySummary.Builder> resourcePolicySummary) {
            return this.resourcePolicySummary((ResourcePolicySummary)((ResourcePolicySummary.Builder)ResourcePolicySummary.builder().applyMutation(resourcePolicySummary)).build());
        }

        public Builder content(String var1);
    }
}

