/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.organizations.model.OrganizationsResponse;
import software.amazon.awssdk.services.organizations.model.ResponsibilityTransfer;
import software.amazon.awssdk.services.organizations.model.ResponsibilityTransfersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInboundResponsibilityTransfersResponse
extends OrganizationsResponse
implements ToCopyableBuilder<Builder, ListInboundResponsibilityTransfersResponse> {
    private static final SdkField<List<ResponsibilityTransfer>> RESPONSIBILITY_TRANSFERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResponsibilityTransfers").getter(ListInboundResponsibilityTransfersResponse.getter(ListInboundResponsibilityTransfersResponse::responsibilityTransfers)).setter(ListInboundResponsibilityTransfersResponse.setter(Builder::responsibilityTransfers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponsibilityTransfers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResponsibilityTransfer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListInboundResponsibilityTransfersResponse.getter(ListInboundResponsibilityTransfersResponse::nextToken)).setter(ListInboundResponsibilityTransfersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESPONSIBILITY_TRANSFERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListInboundResponsibilityTransfersResponse.memberNameToFieldInitializer();
    private final List<ResponsibilityTransfer> responsibilityTransfers;
    private final String nextToken;

    private ListInboundResponsibilityTransfersResponse(BuilderImpl builder) {
        super(builder);
        this.responsibilityTransfers = builder.responsibilityTransfers;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasResponsibilityTransfers() {
        return this.responsibilityTransfers != null && !(this.responsibilityTransfers instanceof SdkAutoConstructList);
    }

    public final List<ResponsibilityTransfer> responsibilityTransfers() {
        return this.responsibilityTransfers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponsibilityTransfers() ? this.responsibilityTransfers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInboundResponsibilityTransfersResponse)) {
            return false;
        }
        ListInboundResponsibilityTransfersResponse other = (ListInboundResponsibilityTransfersResponse)((Object)obj);
        return this.hasResponsibilityTransfers() == other.hasResponsibilityTransfers() && Objects.equals(this.responsibilityTransfers(), other.responsibilityTransfers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListInboundResponsibilityTransfersResponse").add("ResponsibilityTransfers", this.hasResponsibilityTransfers() ? this.responsibilityTransfers() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResponsibilityTransfers": {
                return Optional.ofNullable(clazz.cast(this.responsibilityTransfers()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResponsibilityTransfers", RESPONSIBILITY_TRANSFERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInboundResponsibilityTransfersResponse, T> g) {
        return obj -> g.apply((ListInboundResponsibilityTransfersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OrganizationsResponse.BuilderImpl
    implements Builder {
        private List<ResponsibilityTransfer> responsibilityTransfers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInboundResponsibilityTransfersResponse model) {
            super(model);
            this.responsibilityTransfers(model.responsibilityTransfers);
            this.nextToken(model.nextToken);
        }

        public final List<ResponsibilityTransfer.Builder> getResponsibilityTransfers() {
            List<ResponsibilityTransfer.Builder> result = ResponsibilityTransfersCopier.copyToBuilder(this.responsibilityTransfers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResponsibilityTransfers(Collection<ResponsibilityTransfer.BuilderImpl> responsibilityTransfers) {
            this.responsibilityTransfers = ResponsibilityTransfersCopier.copyFromBuilder(responsibilityTransfers);
        }

        @Override
        public final Builder responsibilityTransfers(Collection<ResponsibilityTransfer> responsibilityTransfers) {
            this.responsibilityTransfers = ResponsibilityTransfersCopier.copy(responsibilityTransfers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responsibilityTransfers(ResponsibilityTransfer ... responsibilityTransfers) {
            this.responsibilityTransfers(Arrays.asList(responsibilityTransfers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responsibilityTransfers(Consumer<ResponsibilityTransfer.Builder> ... responsibilityTransfers) {
            this.responsibilityTransfers(Stream.of(responsibilityTransfers).map(c -> (ResponsibilityTransfer)((ResponsibilityTransfer.Builder)ResponsibilityTransfer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInboundResponsibilityTransfersResponse build() {
            return new ListInboundResponsibilityTransfersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OrganizationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInboundResponsibilityTransfersResponse> {
        public Builder responsibilityTransfers(Collection<ResponsibilityTransfer> var1);

        public Builder responsibilityTransfers(ResponsibilityTransfer ... var1);

        public Builder responsibilityTransfers(Consumer<ResponsibilityTransfer.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

