/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.organizations.model.IAMUserAccessToBilling;
import software.amazon.awssdk.services.organizations.model.OrganizationsRequest;
import software.amazon.awssdk.services.organizations.model.Tag;
import software.amazon.awssdk.services.organizations.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGovCloudAccountRequest
extends OrganizationsRequest
implements ToCopyableBuilder<Builder, CreateGovCloudAccountRequest> {
    private static final SdkField<String> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Email").getter(CreateGovCloudAccountRequest.getter(CreateGovCloudAccountRequest::email)).setter(CreateGovCloudAccountRequest.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()}).build();
    private static final SdkField<String> ACCOUNT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountName").getter(CreateGovCloudAccountRequest.getter(CreateGovCloudAccountRequest::accountName)).setter(CreateGovCloudAccountRequest.setter(Builder::accountName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountName").build()}).build();
    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleName").getter(CreateGovCloudAccountRequest.getter(CreateGovCloudAccountRequest::roleName)).setter(CreateGovCloudAccountRequest.setter(Builder::roleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleName").build()}).build();
    private static final SdkField<String> IAM_USER_ACCESS_TO_BILLING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamUserAccessToBilling").getter(CreateGovCloudAccountRequest.getter(CreateGovCloudAccountRequest::iamUserAccessToBillingAsString)).setter(CreateGovCloudAccountRequest.setter(Builder::iamUserAccessToBilling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamUserAccessToBilling").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateGovCloudAccountRequest.getter(CreateGovCloudAccountRequest::tags)).setter(CreateGovCloudAccountRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_FIELD, ACCOUNT_NAME_FIELD, ROLE_NAME_FIELD, IAM_USER_ACCESS_TO_BILLING_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateGovCloudAccountRequest.memberNameToFieldInitializer();
    private final String email;
    private final String accountName;
    private final String roleName;
    private final String iamUserAccessToBilling;
    private final List<Tag> tags;

    private CreateGovCloudAccountRequest(BuilderImpl builder) {
        super(builder);
        this.email = builder.email;
        this.accountName = builder.accountName;
        this.roleName = builder.roleName;
        this.iamUserAccessToBilling = builder.iamUserAccessToBilling;
        this.tags = builder.tags;
    }

    public final String email() {
        return this.email;
    }

    public final String accountName() {
        return this.accountName;
    }

    public final String roleName() {
        return this.roleName;
    }

    public final IAMUserAccessToBilling iamUserAccessToBilling() {
        return IAMUserAccessToBilling.fromValue(this.iamUserAccessToBilling);
    }

    public final String iamUserAccessToBillingAsString() {
        return this.iamUserAccessToBilling;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamUserAccessToBillingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGovCloudAccountRequest)) {
            return false;
        }
        CreateGovCloudAccountRequest other = (CreateGovCloudAccountRequest)((Object)obj);
        return Objects.equals(this.email(), other.email()) && Objects.equals(this.accountName(), other.accountName()) && Objects.equals(this.roleName(), other.roleName()) && Objects.equals(this.iamUserAccessToBillingAsString(), other.iamUserAccessToBillingAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateGovCloudAccountRequest").add("Email", (Object)(this.email() == null ? null : "*** Sensitive Data Redacted ***")).add("AccountName", (Object)(this.accountName() == null ? null : "*** Sensitive Data Redacted ***")).add("RoleName", (Object)this.roleName()).add("IamUserAccessToBilling", (Object)this.iamUserAccessToBillingAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
            case "AccountName": {
                return Optional.ofNullable(clazz.cast(this.accountName()));
            }
            case "RoleName": {
                return Optional.ofNullable(clazz.cast(this.roleName()));
            }
            case "IamUserAccessToBilling": {
                return Optional.ofNullable(clazz.cast(this.iamUserAccessToBillingAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Email", EMAIL_FIELD);
        map.put("AccountName", ACCOUNT_NAME_FIELD);
        map.put("RoleName", ROLE_NAME_FIELD);
        map.put("IamUserAccessToBilling", IAM_USER_ACCESS_TO_BILLING_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGovCloudAccountRequest, T> g) {
        return obj -> g.apply((CreateGovCloudAccountRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OrganizationsRequest.BuilderImpl
    implements Builder {
        private String email;
        private String accountName;
        private String roleName;
        private String iamUserAccessToBilling;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGovCloudAccountRequest model) {
            super(model);
            this.email(model.email);
            this.accountName(model.accountName);
            this.roleName(model.roleName);
            this.iamUserAccessToBilling(model.iamUserAccessToBilling);
            this.tags(model.tags);
        }

        public final String getEmail() {
            return this.email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getAccountName() {
            return this.accountName;
        }

        public final void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        @Override
        public final Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public final String getRoleName() {
            return this.roleName;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final String getIamUserAccessToBilling() {
            return this.iamUserAccessToBilling;
        }

        public final void setIamUserAccessToBilling(String iamUserAccessToBilling) {
            this.iamUserAccessToBilling = iamUserAccessToBilling;
        }

        @Override
        public final Builder iamUserAccessToBilling(String iamUserAccessToBilling) {
            this.iamUserAccessToBilling = iamUserAccessToBilling;
            return this;
        }

        @Override
        public final Builder iamUserAccessToBilling(IAMUserAccessToBilling iamUserAccessToBilling) {
            this.iamUserAccessToBilling(iamUserAccessToBilling == null ? null : iamUserAccessToBilling.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGovCloudAccountRequest build() {
            return new CreateGovCloudAccountRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OrganizationsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGovCloudAccountRequest> {
        public Builder email(String var1);

        public Builder accountName(String var1);

        public Builder roleName(String var1);

        public Builder iamUserAccessToBilling(String var1);

        public Builder iamUserAccessToBilling(IAMUserAccessToBilling var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

