/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AccountState {
    PENDING_ACTIVATION("PENDING_ACTIVATION"),
    ACTIVE("ACTIVE"),
    SUSPENDED("SUSPENDED"),
    PENDING_CLOSURE("PENDING_CLOSURE"),
    CLOSED("CLOSED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AccountState> VALUE_MAP;
    private final String value;

    private AccountState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccountState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccountState> knownValues() {
        EnumSet<AccountState> knownValues = EnumSet.allOf(AccountState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AccountState.class, AccountState::toString);
    }
}

