/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.internal.UserAgentUtils;
import software.amazon.awssdk.services.organizations.model.DelegatedAdministrator;
import software.amazon.awssdk.services.organizations.model.ListDelegatedAdministratorsRequest;
import software.amazon.awssdk.services.organizations.model.ListDelegatedAdministratorsResponse;

public class ListDelegatedAdministratorsIterable
implements SdkIterable<ListDelegatedAdministratorsResponse> {
    private final OrganizationsClient client;
    private final ListDelegatedAdministratorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDelegatedAdministratorsIterable(OrganizationsClient client, ListDelegatedAdministratorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDelegatedAdministratorsResponseFetcher();
    }

    public Iterator<ListDelegatedAdministratorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DelegatedAdministrator> delegatedAdministrators() {
        Function<ListDelegatedAdministratorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.delegatedAdministrators() != null) {
                return response.delegatedAdministrators().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDelegatedAdministratorsResponseFetcher
    implements SyncPageFetcher<ListDelegatedAdministratorsResponse> {
        private ListDelegatedAdministratorsResponseFetcher() {
        }

        public boolean hasNextPage(ListDelegatedAdministratorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDelegatedAdministratorsResponse nextPage(ListDelegatedAdministratorsResponse previousPage) {
            if (previousPage == null) {
                return ListDelegatedAdministratorsIterable.this.client.listDelegatedAdministrators(ListDelegatedAdministratorsIterable.this.firstRequest);
            }
            return ListDelegatedAdministratorsIterable.this.client.listDelegatedAdministrators((ListDelegatedAdministratorsRequest)((Object)ListDelegatedAdministratorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

