/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SecurityConfigType {
    SAML("saml"),
    IAMIDENTITYCENTER("iamidentitycenter"),
    IAMFEDERATION("iamfederation"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SecurityConfigType> VALUE_MAP;
    private final String value;

    private SecurityConfigType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SecurityConfigType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SecurityConfigType> knownValues() {
        EnumSet<SecurityConfigType> knownValues = EnumSet.allOf(SecurityConfigType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SecurityConfigType.class, SecurityConfigType::toString);
    }
}

