/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyDetail;
import software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyDetailsCopier;
import software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyErrorDetail;
import software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyErrorDetailsCopier;
import software.amazon.awssdk.services.opensearchserverless.model.OpenSearchServerlessResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetLifecyclePolicyResponse
extends OpenSearchServerlessResponse
implements ToCopyableBuilder<Builder, BatchGetLifecyclePolicyResponse> {
    private static final SdkField<List<LifecyclePolicyDetail>> LIFECYCLE_POLICY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("lifecyclePolicyDetails").getter(BatchGetLifecyclePolicyResponse.getter(BatchGetLifecyclePolicyResponse::lifecyclePolicyDetails)).setter(BatchGetLifecyclePolicyResponse.setter(Builder::lifecyclePolicyDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecyclePolicyDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LifecyclePolicyDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LifecyclePolicyErrorDetail>> LIFECYCLE_POLICY_ERROR_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("lifecyclePolicyErrorDetails").getter(BatchGetLifecyclePolicyResponse.getter(BatchGetLifecyclePolicyResponse::lifecyclePolicyErrorDetails)).setter(BatchGetLifecyclePolicyResponse.setter(Builder::lifecyclePolicyErrorDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecyclePolicyErrorDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LifecyclePolicyErrorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_POLICY_DETAILS_FIELD, LIFECYCLE_POLICY_ERROR_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetLifecyclePolicyResponse.memberNameToFieldInitializer();
    private final List<LifecyclePolicyDetail> lifecyclePolicyDetails;
    private final List<LifecyclePolicyErrorDetail> lifecyclePolicyErrorDetails;

    private BatchGetLifecyclePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.lifecyclePolicyDetails = builder.lifecyclePolicyDetails;
        this.lifecyclePolicyErrorDetails = builder.lifecyclePolicyErrorDetails;
    }

    public final boolean hasLifecyclePolicyDetails() {
        return this.lifecyclePolicyDetails != null && !(this.lifecyclePolicyDetails instanceof SdkAutoConstructList);
    }

    public final List<LifecyclePolicyDetail> lifecyclePolicyDetails() {
        return this.lifecyclePolicyDetails;
    }

    public final boolean hasLifecyclePolicyErrorDetails() {
        return this.lifecyclePolicyErrorDetails != null && !(this.lifecyclePolicyErrorDetails instanceof SdkAutoConstructList);
    }

    public final List<LifecyclePolicyErrorDetail> lifecyclePolicyErrorDetails() {
        return this.lifecyclePolicyErrorDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLifecyclePolicyDetails() ? this.lifecyclePolicyDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLifecyclePolicyErrorDetails() ? this.lifecyclePolicyErrorDetails() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetLifecyclePolicyResponse)) {
            return false;
        }
        BatchGetLifecyclePolicyResponse other = (BatchGetLifecyclePolicyResponse)((Object)obj);
        return this.hasLifecyclePolicyDetails() == other.hasLifecyclePolicyDetails() && Objects.equals(this.lifecyclePolicyDetails(), other.lifecyclePolicyDetails()) && this.hasLifecyclePolicyErrorDetails() == other.hasLifecyclePolicyErrorDetails() && Objects.equals(this.lifecyclePolicyErrorDetails(), other.lifecyclePolicyErrorDetails());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetLifecyclePolicyResponse").add("LifecyclePolicyDetails", this.hasLifecyclePolicyDetails() ? this.lifecyclePolicyDetails() : null).add("LifecyclePolicyErrorDetails", this.hasLifecyclePolicyErrorDetails() ? this.lifecyclePolicyErrorDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lifecyclePolicyDetails": {
                return Optional.ofNullable(clazz.cast(this.lifecyclePolicyDetails()));
            }
            case "lifecyclePolicyErrorDetails": {
                return Optional.ofNullable(clazz.cast(this.lifecyclePolicyErrorDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("lifecyclePolicyDetails", LIFECYCLE_POLICY_DETAILS_FIELD);
        map.put("lifecyclePolicyErrorDetails", LIFECYCLE_POLICY_ERROR_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetLifecyclePolicyResponse, T> g) {
        return obj -> g.apply((BatchGetLifecyclePolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchServerlessResponse.BuilderImpl
    implements Builder {
        private List<LifecyclePolicyDetail> lifecyclePolicyDetails = DefaultSdkAutoConstructList.getInstance();
        private List<LifecyclePolicyErrorDetail> lifecyclePolicyErrorDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetLifecyclePolicyResponse model) {
            super(model);
            this.lifecyclePolicyDetails(model.lifecyclePolicyDetails);
            this.lifecyclePolicyErrorDetails(model.lifecyclePolicyErrorDetails);
        }

        public final List<LifecyclePolicyDetail.Builder> getLifecyclePolicyDetails() {
            List<LifecyclePolicyDetail.Builder> result = LifecyclePolicyDetailsCopier.copyToBuilder(this.lifecyclePolicyDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLifecyclePolicyDetails(Collection<LifecyclePolicyDetail.BuilderImpl> lifecyclePolicyDetails) {
            this.lifecyclePolicyDetails = LifecyclePolicyDetailsCopier.copyFromBuilder(lifecyclePolicyDetails);
        }

        @Override
        public final Builder lifecyclePolicyDetails(Collection<LifecyclePolicyDetail> lifecyclePolicyDetails) {
            this.lifecyclePolicyDetails = LifecyclePolicyDetailsCopier.copy(lifecyclePolicyDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecyclePolicyDetails(LifecyclePolicyDetail ... lifecyclePolicyDetails) {
            this.lifecyclePolicyDetails(Arrays.asList(lifecyclePolicyDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecyclePolicyDetails(Consumer<LifecyclePolicyDetail.Builder> ... lifecyclePolicyDetails) {
            this.lifecyclePolicyDetails(Stream.of(lifecyclePolicyDetails).map(c -> (LifecyclePolicyDetail)((LifecyclePolicyDetail.Builder)LifecyclePolicyDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<LifecyclePolicyErrorDetail.Builder> getLifecyclePolicyErrorDetails() {
            List<LifecyclePolicyErrorDetail.Builder> result = LifecyclePolicyErrorDetailsCopier.copyToBuilder(this.lifecyclePolicyErrorDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLifecyclePolicyErrorDetails(Collection<LifecyclePolicyErrorDetail.BuilderImpl> lifecyclePolicyErrorDetails) {
            this.lifecyclePolicyErrorDetails = LifecyclePolicyErrorDetailsCopier.copyFromBuilder(lifecyclePolicyErrorDetails);
        }

        @Override
        public final Builder lifecyclePolicyErrorDetails(Collection<LifecyclePolicyErrorDetail> lifecyclePolicyErrorDetails) {
            this.lifecyclePolicyErrorDetails = LifecyclePolicyErrorDetailsCopier.copy(lifecyclePolicyErrorDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecyclePolicyErrorDetails(LifecyclePolicyErrorDetail ... lifecyclePolicyErrorDetails) {
            this.lifecyclePolicyErrorDetails(Arrays.asList(lifecyclePolicyErrorDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecyclePolicyErrorDetails(Consumer<LifecyclePolicyErrorDetail.Builder> ... lifecyclePolicyErrorDetails) {
            this.lifecyclePolicyErrorDetails(Stream.of(lifecyclePolicyErrorDetails).map(c -> (LifecyclePolicyErrorDetail)((LifecyclePolicyErrorDetail.Builder)LifecyclePolicyErrorDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetLifecyclePolicyResponse build() {
            return new BatchGetLifecyclePolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OpenSearchServerlessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetLifecyclePolicyResponse> {
        public Builder lifecyclePolicyDetails(Collection<LifecyclePolicyDetail> var1);

        public Builder lifecyclePolicyDetails(LifecyclePolicyDetail ... var1);

        public Builder lifecyclePolicyDetails(Consumer<LifecyclePolicyDetail.Builder> ... var1);

        public Builder lifecyclePolicyErrorDetails(Collection<LifecyclePolicyErrorDetail> var1);

        public Builder lifecyclePolicyErrorDetails(LifecyclePolicyErrorDetail ... var1);

        public Builder lifecyclePolicyErrorDetails(Consumer<LifecyclePolicyErrorDetail.Builder> ... var1);
    }
}

