/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.OpenSearchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIndexResponse
extends OpenSearchResponse
implements ToCopyableBuilder<Builder, GetIndexResponse> {
    private static final SdkField<Document> INDEX_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("IndexSchema").getter(GetIndexResponse.getter(GetIndexResponse::indexSchema)).setter(GetIndexResponse.setter(Builder::indexSchema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexSchema").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_SCHEMA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetIndexResponse.memberNameToFieldInitializer();
    private final Document indexSchema;

    private GetIndexResponse(BuilderImpl builder) {
        super(builder);
        this.indexSchema = builder.indexSchema;
    }

    public final Document indexSchema() {
        return this.indexSchema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.indexSchema());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIndexResponse)) {
            return false;
        }
        GetIndexResponse other = (GetIndexResponse)((Object)obj);
        return Objects.equals(this.indexSchema(), other.indexSchema());
    }

    public final String toString() {
        return ToString.builder((String)"GetIndexResponse").add("IndexSchema", (Object)this.indexSchema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexSchema": {
                return Optional.ofNullable(clazz.cast(this.indexSchema()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Document>> map = new HashMap<String, SdkField<Document>>();
        map.put("IndexSchema", INDEX_SCHEMA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIndexResponse, T> g) {
        return obj -> g.apply((GetIndexResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchResponse.BuilderImpl
    implements Builder {
        private Document indexSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIndexResponse model) {
            super(model);
            this.indexSchema(model.indexSchema);
        }

        public final Document getIndexSchema() {
            return this.indexSchema;
        }

        public final void setIndexSchema(Document indexSchema) {
            this.indexSchema = indexSchema;
        }

        @Override
        public final Builder indexSchema(Document indexSchema) {
            this.indexSchema = indexSchema;
            return this;
        }

        @Override
        public GetIndexResponse build() {
            return new GetIndexResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OpenSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIndexResponse> {
        public Builder indexSchema(Document var1);
    }
}

