/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.NaturalLanguageQueryGenerationOptionsInput;
import software.amazon.awssdk.services.opensearch.model.S3VectorsEngine;
import software.amazon.awssdk.services.opensearch.model.ServerlessVectorAcceleration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AIMLOptionsInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AIMLOptionsInput> {
    private static final SdkField<NaturalLanguageQueryGenerationOptionsInput> NATURAL_LANGUAGE_QUERY_GENERATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NaturalLanguageQueryGenerationOptions").getter(AIMLOptionsInput.getter(AIMLOptionsInput::naturalLanguageQueryGenerationOptions)).setter(AIMLOptionsInput.setter(Builder::naturalLanguageQueryGenerationOptions)).constructor(NaturalLanguageQueryGenerationOptionsInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NaturalLanguageQueryGenerationOptions").build()}).build();
    private static final SdkField<S3VectorsEngine> S3_VECTORS_ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3VectorsEngine").getter(AIMLOptionsInput.getter(AIMLOptionsInput::s3VectorsEngine)).setter(AIMLOptionsInput.setter(Builder::s3VectorsEngine)).constructor(S3VectorsEngine::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3VectorsEngine").build()}).build();
    private static final SdkField<ServerlessVectorAcceleration> SERVERLESS_VECTOR_ACCELERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServerlessVectorAcceleration").getter(AIMLOptionsInput.getter(AIMLOptionsInput::serverlessVectorAcceleration)).setter(AIMLOptionsInput.setter(Builder::serverlessVectorAcceleration)).constructor(ServerlessVectorAcceleration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessVectorAcceleration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NATURAL_LANGUAGE_QUERY_GENERATION_OPTIONS_FIELD, S3_VECTORS_ENGINE_FIELD, SERVERLESS_VECTOR_ACCELERATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AIMLOptionsInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final NaturalLanguageQueryGenerationOptionsInput naturalLanguageQueryGenerationOptions;
    private final S3VectorsEngine s3VectorsEngine;
    private final ServerlessVectorAcceleration serverlessVectorAcceleration;

    private AIMLOptionsInput(BuilderImpl builder) {
        this.naturalLanguageQueryGenerationOptions = builder.naturalLanguageQueryGenerationOptions;
        this.s3VectorsEngine = builder.s3VectorsEngine;
        this.serverlessVectorAcceleration = builder.serverlessVectorAcceleration;
    }

    public final NaturalLanguageQueryGenerationOptionsInput naturalLanguageQueryGenerationOptions() {
        return this.naturalLanguageQueryGenerationOptions;
    }

    public final S3VectorsEngine s3VectorsEngine() {
        return this.s3VectorsEngine;
    }

    public final ServerlessVectorAcceleration serverlessVectorAcceleration() {
        return this.serverlessVectorAcceleration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.naturalLanguageQueryGenerationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3VectorsEngine());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverlessVectorAcceleration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AIMLOptionsInput)) {
            return false;
        }
        AIMLOptionsInput other = (AIMLOptionsInput)obj;
        return Objects.equals(this.naturalLanguageQueryGenerationOptions(), other.naturalLanguageQueryGenerationOptions()) && Objects.equals(this.s3VectorsEngine(), other.s3VectorsEngine()) && Objects.equals(this.serverlessVectorAcceleration(), other.serverlessVectorAcceleration());
    }

    public final String toString() {
        return ToString.builder((String)"AIMLOptionsInput").add("NaturalLanguageQueryGenerationOptions", (Object)this.naturalLanguageQueryGenerationOptions()).add("S3VectorsEngine", (Object)this.s3VectorsEngine()).add("ServerlessVectorAcceleration", (Object)this.serverlessVectorAcceleration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NaturalLanguageQueryGenerationOptions": {
                return Optional.ofNullable(clazz.cast(this.naturalLanguageQueryGenerationOptions()));
            }
            case "S3VectorsEngine": {
                return Optional.ofNullable(clazz.cast(this.s3VectorsEngine()));
            }
            case "ServerlessVectorAcceleration": {
                return Optional.ofNullable(clazz.cast(this.serverlessVectorAcceleration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NaturalLanguageQueryGenerationOptions", NATURAL_LANGUAGE_QUERY_GENERATION_OPTIONS_FIELD);
        map.put("S3VectorsEngine", S3_VECTORS_ENGINE_FIELD);
        map.put("ServerlessVectorAcceleration", SERVERLESS_VECTOR_ACCELERATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AIMLOptionsInput, T> g) {
        return obj -> g.apply((AIMLOptionsInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private NaturalLanguageQueryGenerationOptionsInput naturalLanguageQueryGenerationOptions;
        private S3VectorsEngine s3VectorsEngine;
        private ServerlessVectorAcceleration serverlessVectorAcceleration;

        private BuilderImpl() {
        }

        private BuilderImpl(AIMLOptionsInput model) {
            this.naturalLanguageQueryGenerationOptions(model.naturalLanguageQueryGenerationOptions);
            this.s3VectorsEngine(model.s3VectorsEngine);
            this.serverlessVectorAcceleration(model.serverlessVectorAcceleration);
        }

        public final NaturalLanguageQueryGenerationOptionsInput.Builder getNaturalLanguageQueryGenerationOptions() {
            return this.naturalLanguageQueryGenerationOptions != null ? this.naturalLanguageQueryGenerationOptions.toBuilder() : null;
        }

        public final void setNaturalLanguageQueryGenerationOptions(NaturalLanguageQueryGenerationOptionsInput.BuilderImpl naturalLanguageQueryGenerationOptions) {
            this.naturalLanguageQueryGenerationOptions = naturalLanguageQueryGenerationOptions != null ? naturalLanguageQueryGenerationOptions.build() : null;
        }

        @Override
        public final Builder naturalLanguageQueryGenerationOptions(NaturalLanguageQueryGenerationOptionsInput naturalLanguageQueryGenerationOptions) {
            this.naturalLanguageQueryGenerationOptions = naturalLanguageQueryGenerationOptions;
            return this;
        }

        public final S3VectorsEngine.Builder getS3VectorsEngine() {
            return this.s3VectorsEngine != null ? this.s3VectorsEngine.toBuilder() : null;
        }

        public final void setS3VectorsEngine(S3VectorsEngine.BuilderImpl s3VectorsEngine) {
            this.s3VectorsEngine = s3VectorsEngine != null ? s3VectorsEngine.build() : null;
        }

        @Override
        public final Builder s3VectorsEngine(S3VectorsEngine s3VectorsEngine) {
            this.s3VectorsEngine = s3VectorsEngine;
            return this;
        }

        public final ServerlessVectorAcceleration.Builder getServerlessVectorAcceleration() {
            return this.serverlessVectorAcceleration != null ? this.serverlessVectorAcceleration.toBuilder() : null;
        }

        public final void setServerlessVectorAcceleration(ServerlessVectorAcceleration.BuilderImpl serverlessVectorAcceleration) {
            this.serverlessVectorAcceleration = serverlessVectorAcceleration != null ? serverlessVectorAcceleration.build() : null;
        }

        @Override
        public final Builder serverlessVectorAcceleration(ServerlessVectorAcceleration serverlessVectorAcceleration) {
            this.serverlessVectorAcceleration = serverlessVectorAcceleration;
            return this;
        }

        public AIMLOptionsInput build() {
            return new AIMLOptionsInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AIMLOptionsInput> {
        public Builder naturalLanguageQueryGenerationOptions(NaturalLanguageQueryGenerationOptionsInput var1);

        default public Builder naturalLanguageQueryGenerationOptions(Consumer<NaturalLanguageQueryGenerationOptionsInput.Builder> naturalLanguageQueryGenerationOptions) {
            return this.naturalLanguageQueryGenerationOptions((NaturalLanguageQueryGenerationOptionsInput)((NaturalLanguageQueryGenerationOptionsInput.Builder)NaturalLanguageQueryGenerationOptionsInput.builder().applyMutation(naturalLanguageQueryGenerationOptions)).build());
        }

        public Builder s3VectorsEngine(S3VectorsEngine var1);

        default public Builder s3VectorsEngine(Consumer<S3VectorsEngine.Builder> s3VectorsEngine) {
            return this.s3VectorsEngine((S3VectorsEngine)((S3VectorsEngine.Builder)S3VectorsEngine.builder().applyMutation(s3VectorsEngine)).build());
        }

        public Builder serverlessVectorAcceleration(ServerlessVectorAcceleration var1);

        default public Builder serverlessVectorAcceleration(Consumer<ServerlessVectorAcceleration.Builder> serverlessVectorAcceleration) {
            return this.serverlessVectorAcceleration((ServerlessVectorAcceleration)((ServerlessVectorAcceleration.Builder)ServerlessVectorAcceleration.builder().applyMutation(serverlessVectorAcceleration)).build());
        }
    }
}

