/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearch.OpenSearchClient;
import software.amazon.awssdk.services.opensearch.internal.UserAgentUtils;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesResponse;

public class DescribeDomainAutoTunesIterable
implements SdkIterable<DescribeDomainAutoTunesResponse> {
    private final OpenSearchClient client;
    private final DescribeDomainAutoTunesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDomainAutoTunesIterable(OpenSearchClient client, DescribeDomainAutoTunesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeDomainAutoTunesResponseFetcher();
    }

    public Iterator<DescribeDomainAutoTunesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeDomainAutoTunesResponseFetcher
    implements SyncPageFetcher<DescribeDomainAutoTunesResponse> {
        private DescribeDomainAutoTunesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDomainAutoTunesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeDomainAutoTunesResponse nextPage(DescribeDomainAutoTunesResponse previousPage) {
            if (previousPage == null) {
                return DescribeDomainAutoTunesIterable.this.client.describeDomainAutoTunes(DescribeDomainAutoTunesIterable.this.firstRequest);
            }
            return DescribeDomainAutoTunesIterable.this.client.describeDomainAutoTunes((DescribeDomainAutoTunesRequest)((Object)DescribeDomainAutoTunesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

