/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IAMFederationOptionsOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IAMFederationOptionsOutput> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(IAMFederationOptionsOutput.getter(IAMFederationOptionsOutput::enabled)).setter(IAMFederationOptionsOutput.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<String> SUBJECT_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubjectKey").getter(IAMFederationOptionsOutput.getter(IAMFederationOptionsOutput::subjectKey)).setter(IAMFederationOptionsOutput.setter(Builder::subjectKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubjectKey").build()}).build();
    private static final SdkField<String> ROLES_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RolesKey").getter(IAMFederationOptionsOutput.getter(IAMFederationOptionsOutput::rolesKey)).setter(IAMFederationOptionsOutput.setter(Builder::rolesKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RolesKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, SUBJECT_KEY_FIELD, ROLES_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IAMFederationOptionsOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final String subjectKey;
    private final String rolesKey;

    private IAMFederationOptionsOutput(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.subjectKey = builder.subjectKey;
        this.rolesKey = builder.rolesKey;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final String subjectKey() {
        return this.subjectKey;
    }

    public final String rolesKey() {
        return this.rolesKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.subjectKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.rolesKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IAMFederationOptionsOutput)) {
            return false;
        }
        IAMFederationOptionsOutput other = (IAMFederationOptionsOutput)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.subjectKey(), other.subjectKey()) && Objects.equals(this.rolesKey(), other.rolesKey());
    }

    public final String toString() {
        return ToString.builder((String)"IAMFederationOptionsOutput").add("Enabled", (Object)this.enabled()).add("SubjectKey", (Object)this.subjectKey()).add("RolesKey", (Object)this.rolesKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "SubjectKey": {
                return Optional.ofNullable(clazz.cast(this.subjectKey()));
            }
            case "RolesKey": {
                return Optional.ofNullable(clazz.cast(this.rolesKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Enabled", ENABLED_FIELD);
        map.put("SubjectKey", SUBJECT_KEY_FIELD);
        map.put("RolesKey", ROLES_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IAMFederationOptionsOutput, T> g) {
        return obj -> g.apply((IAMFederationOptionsOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String subjectKey;
        private String rolesKey;

        private BuilderImpl() {
        }

        private BuilderImpl(IAMFederationOptionsOutput model) {
            this.enabled(model.enabled);
            this.subjectKey(model.subjectKey);
            this.rolesKey(model.rolesKey);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getSubjectKey() {
            return this.subjectKey;
        }

        public final void setSubjectKey(String subjectKey) {
            this.subjectKey = subjectKey;
        }

        @Override
        public final Builder subjectKey(String subjectKey) {
            this.subjectKey = subjectKey;
            return this;
        }

        public final String getRolesKey() {
            return this.rolesKey;
        }

        public final void setRolesKey(String rolesKey) {
            this.rolesKey = rolesKey;
        }

        @Override
        public final Builder rolesKey(String rolesKey) {
            this.rolesKey = rolesKey;
            return this;
        }

        public IAMFederationOptionsOutput build() {
            return new IAMFederationOptionsOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IAMFederationOptionsOutput> {
        public Builder enabled(Boolean var1);

        public Builder subjectKey(String var1);

        public Builder rolesKey(String var1);
    }
}

