/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.NodeStatus;
import software.amazon.awssdk.services.opensearch.model.NodeType;
import software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType;
import software.amazon.awssdk.services.opensearch.model.VolumeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainNodesStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainNodesStatus> {
    private static final SdkField<String> NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeId").getter(DomainNodesStatus.getter(DomainNodesStatus::nodeId)).setter(DomainNodesStatus.setter(Builder::nodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeId").build()}).build();
    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeType").getter(DomainNodesStatus.getter(DomainNodesStatus::nodeTypeAsString)).setter(DomainNodesStatus.setter(Builder::nodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(DomainNodesStatus.getter(DomainNodesStatus::availabilityZone)).setter(DomainNodesStatus.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(DomainNodesStatus.getter(DomainNodesStatus::instanceTypeAsString)).setter(DomainNodesStatus.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<String> NODE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeStatus").getter(DomainNodesStatus.getter(DomainNodesStatus::nodeStatusAsString)).setter(DomainNodesStatus.setter(Builder::nodeStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeStatus").build()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageType").getter(DomainNodesStatus.getter(DomainNodesStatus::storageType)).setter(DomainNodesStatus.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()}).build();
    private static final SdkField<String> STORAGE_VOLUME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageVolumeType").getter(DomainNodesStatus.getter(DomainNodesStatus::storageVolumeTypeAsString)).setter(DomainNodesStatus.setter(Builder::storageVolumeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageVolumeType").build()}).build();
    private static final SdkField<String> STORAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageSize").getter(DomainNodesStatus.getter(DomainNodesStatus::storageSize)).setter(DomainNodesStatus.setter(Builder::storageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_ID_FIELD, NODE_TYPE_FIELD, AVAILABILITY_ZONE_FIELD, INSTANCE_TYPE_FIELD, NODE_STATUS_FIELD, STORAGE_TYPE_FIELD, STORAGE_VOLUME_TYPE_FIELD, STORAGE_SIZE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DomainNodesStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String nodeId;
    private final String nodeType;
    private final String availabilityZone;
    private final String instanceType;
    private final String nodeStatus;
    private final String storageType;
    private final String storageVolumeType;
    private final String storageSize;

    private DomainNodesStatus(BuilderImpl builder) {
        this.nodeId = builder.nodeId;
        this.nodeType = builder.nodeType;
        this.availabilityZone = builder.availabilityZone;
        this.instanceType = builder.instanceType;
        this.nodeStatus = builder.nodeStatus;
        this.storageType = builder.storageType;
        this.storageVolumeType = builder.storageVolumeType;
        this.storageSize = builder.storageSize;
    }

    public final String nodeId() {
        return this.nodeId;
    }

    public final NodeType nodeType() {
        return NodeType.fromValue(this.nodeType);
    }

    public final String nodeTypeAsString() {
        return this.nodeType;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final OpenSearchPartitionInstanceType instanceType() {
        return OpenSearchPartitionInstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final NodeStatus nodeStatus() {
        return NodeStatus.fromValue(this.nodeStatus);
    }

    public final String nodeStatusAsString() {
        return this.nodeStatus;
    }

    public final String storageType() {
        return this.storageType;
    }

    public final VolumeType storageVolumeType() {
        return VolumeType.fromValue(this.storageVolumeType);
    }

    public final String storageVolumeTypeAsString() {
        return this.storageVolumeType;
    }

    public final String storageSize() {
        return this.storageSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageVolumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageSize());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainNodesStatus)) {
            return false;
        }
        DomainNodesStatus other = (DomainNodesStatus)obj;
        return Objects.equals(this.nodeId(), other.nodeId()) && Objects.equals(this.nodeTypeAsString(), other.nodeTypeAsString()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.nodeStatusAsString(), other.nodeStatusAsString()) && Objects.equals(this.storageType(), other.storageType()) && Objects.equals(this.storageVolumeTypeAsString(), other.storageVolumeTypeAsString()) && Objects.equals(this.storageSize(), other.storageSize());
    }

    public final String toString() {
        return ToString.builder((String)"DomainNodesStatus").add("NodeId", (Object)this.nodeId()).add("NodeType", (Object)this.nodeTypeAsString()).add("AvailabilityZone", (Object)this.availabilityZone()).add("InstanceType", (Object)this.instanceTypeAsString()).add("NodeStatus", (Object)this.nodeStatusAsString()).add("StorageType", (Object)this.storageType()).add("StorageVolumeType", (Object)this.storageVolumeTypeAsString()).add("StorageSize", (Object)this.storageSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NodeId": {
                return Optional.ofNullable(clazz.cast(this.nodeId()));
            }
            case "NodeType": {
                return Optional.ofNullable(clazz.cast(this.nodeTypeAsString()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "NodeStatus": {
                return Optional.ofNullable(clazz.cast(this.nodeStatusAsString()));
            }
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageType()));
            }
            case "StorageVolumeType": {
                return Optional.ofNullable(clazz.cast(this.storageVolumeTypeAsString()));
            }
            case "StorageSize": {
                return Optional.ofNullable(clazz.cast(this.storageSize()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("NodeId", NODE_ID_FIELD);
        map.put("NodeType", NODE_TYPE_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("NodeStatus", NODE_STATUS_FIELD);
        map.put("StorageType", STORAGE_TYPE_FIELD);
        map.put("StorageVolumeType", STORAGE_VOLUME_TYPE_FIELD);
        map.put("StorageSize", STORAGE_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DomainNodesStatus, T> g) {
        return obj -> g.apply((DomainNodesStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String nodeId;
        private String nodeType;
        private String availabilityZone;
        private String instanceType;
        private String nodeStatus;
        private String storageType;
        private String storageVolumeType;
        private String storageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainNodesStatus model) {
            this.nodeId(model.nodeId);
            this.nodeType(model.nodeType);
            this.availabilityZone(model.availabilityZone);
            this.instanceType(model.instanceType);
            this.nodeStatus(model.nodeStatus);
            this.storageType(model.storageType);
            this.storageVolumeType(model.storageVolumeType);
            this.storageSize(model.storageSize);
        }

        public final String getNodeId() {
            return this.nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        @Override
        public final Builder nodeType(NodeType nodeType) {
            this.nodeType(nodeType == null ? null : nodeType.toString());
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(OpenSearchPartitionInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getNodeStatus() {
            return this.nodeStatus;
        }

        public final void setNodeStatus(String nodeStatus) {
            this.nodeStatus = nodeStatus;
        }

        @Override
        public final Builder nodeStatus(String nodeStatus) {
            this.nodeStatus = nodeStatus;
            return this;
        }

        @Override
        public final Builder nodeStatus(NodeStatus nodeStatus) {
            this.nodeStatus(nodeStatus == null ? null : nodeStatus.toString());
            return this;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final String getStorageVolumeType() {
            return this.storageVolumeType;
        }

        public final void setStorageVolumeType(String storageVolumeType) {
            this.storageVolumeType = storageVolumeType;
        }

        @Override
        public final Builder storageVolumeType(String storageVolumeType) {
            this.storageVolumeType = storageVolumeType;
            return this;
        }

        @Override
        public final Builder storageVolumeType(VolumeType storageVolumeType) {
            this.storageVolumeType(storageVolumeType == null ? null : storageVolumeType.toString());
            return this;
        }

        public final String getStorageSize() {
            return this.storageSize;
        }

        public final void setStorageSize(String storageSize) {
            this.storageSize = storageSize;
        }

        @Override
        public final Builder storageSize(String storageSize) {
            this.storageSize = storageSize;
            return this;
        }

        public DomainNodesStatus build() {
            return new DomainNodesStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainNodesStatus> {
        public Builder nodeId(String var1);

        public Builder nodeType(String var1);

        public Builder nodeType(NodeType var1);

        public Builder availabilityZone(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(OpenSearchPartitionInstanceType var1);

        public Builder nodeStatus(String var1);

        public Builder nodeStatus(NodeStatus var1);

        public Builder storageType(String var1);

        public Builder storageVolumeType(String var1);

        public Builder storageVolumeType(VolumeType var1);

        public Builder storageSize(String var1);
    }
}

