/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AppConfigType {
    OPENSEARCH_DASHBOARDS_DASHBOARD_ADMIN_USERS("opensearchDashboards.dashboardAdmin.users"),
    OPENSEARCH_DASHBOARDS_DASHBOARD_ADMIN_GROUPS("opensearchDashboards.dashboardAdmin.groups"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AppConfigType> VALUE_MAP;
    private final String value;

    private AppConfigType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AppConfigType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AppConfigType> knownValues() {
        EnumSet<AppConfigType> knownValues = EnumSet.allOf(AppConfigType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AppConfigType.class, AppConfigType::toString);
    }
}

