/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.DataSourceStatus;
import software.amazon.awssdk.services.opensearch.model.DataSourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSourceDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSourceDetails> {
    private static final SdkField<DataSourceType> DATA_SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSourceType").getter(DataSourceDetails.getter(DataSourceDetails::dataSourceType)).setter(DataSourceDetails.setter(Builder::dataSourceType)).constructor(DataSourceType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceType").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DataSourceDetails.getter(DataSourceDetails::name)).setter(DataSourceDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DataSourceDetails.getter(DataSourceDetails::description)).setter(DataSourceDetails.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DataSourceDetails.getter(DataSourceDetails::statusAsString)).setter(DataSourceDetails.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_TYPE_FIELD, NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataSourceDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DataSourceType dataSourceType;
    private final String name;
    private final String description;
    private final String status;

    private DataSourceDetails(BuilderImpl builder) {
        this.dataSourceType = builder.dataSourceType;
        this.name = builder.name;
        this.description = builder.description;
        this.status = builder.status;
    }

    public final DataSourceType dataSourceType() {
        return this.dataSourceType;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final DataSourceStatus status() {
        return DataSourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceDetails)) {
            return false;
        }
        DataSourceDetails other = (DataSourceDetails)obj;
        return Objects.equals(this.dataSourceType(), other.dataSourceType()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DataSourceDetails").add("DataSourceType", (Object)this.dataSourceType()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSourceType": {
                return Optional.ofNullable(clazz.cast(this.dataSourceType()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DataSourceType", DATA_SOURCE_TYPE_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSourceDetails, T> g) {
        return obj -> g.apply((DataSourceDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DataSourceType dataSourceType;
        private String name;
        private String description;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceDetails model) {
            this.dataSourceType(model.dataSourceType);
            this.name(model.name);
            this.description(model.description);
            this.status(model.status);
        }

        public final DataSourceType.Builder getDataSourceType() {
            return this.dataSourceType != null ? this.dataSourceType.toBuilder() : null;
        }

        public final void setDataSourceType(DataSourceType.BuilderImpl dataSourceType) {
            this.dataSourceType = dataSourceType != null ? dataSourceType.build() : null;
        }

        @Override
        public final Builder dataSourceType(DataSourceType dataSourceType) {
            this.dataSourceType = dataSourceType;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataSourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public DataSourceDetails build() {
            return new DataSourceDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSourceDetails> {
        public Builder dataSourceType(DataSourceType var1);

        default public Builder dataSourceType(Consumer<DataSourceType.Builder> dataSourceType) {
            return this.dataSourceType((DataSourceType)((DataSourceType.Builder)DataSourceType.builder().applyMutation(dataSourceType)).build());
        }

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(DataSourceStatus var1);
    }
}

