/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IamIdentityCenterOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IamIdentityCenterOptions> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(IamIdentityCenterOptions.getter(IamIdentityCenterOptions::enabled)).setter(IamIdentityCenterOptions.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<String> IAM_IDENTITY_CENTER_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iamIdentityCenterInstanceArn").getter(IamIdentityCenterOptions.getter(IamIdentityCenterOptions::iamIdentityCenterInstanceArn)).setter(IamIdentityCenterOptions.setter(Builder::iamIdentityCenterInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamIdentityCenterInstanceArn").build()}).build();
    private static final SdkField<String> IAM_ROLE_FOR_IDENTITY_CENTER_APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iamRoleForIdentityCenterApplicationArn").getter(IamIdentityCenterOptions.getter(IamIdentityCenterOptions::iamRoleForIdentityCenterApplicationArn)).setter(IamIdentityCenterOptions.setter(Builder::iamRoleForIdentityCenterApplicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRoleForIdentityCenterApplicationArn").build()}).build();
    private static final SdkField<String> IAM_IDENTITY_CENTER_APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iamIdentityCenterApplicationArn").getter(IamIdentityCenterOptions.getter(IamIdentityCenterOptions::iamIdentityCenterApplicationArn)).setter(IamIdentityCenterOptions.setter(Builder::iamIdentityCenterApplicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamIdentityCenterApplicationArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, IAM_IDENTITY_CENTER_INSTANCE_ARN_FIELD, IAM_ROLE_FOR_IDENTITY_CENTER_APPLICATION_ARN_FIELD, IAM_IDENTITY_CENTER_APPLICATION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IamIdentityCenterOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final String iamIdentityCenterInstanceArn;
    private final String iamRoleForIdentityCenterApplicationArn;
    private final String iamIdentityCenterApplicationArn;

    private IamIdentityCenterOptions(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.iamIdentityCenterInstanceArn = builder.iamIdentityCenterInstanceArn;
        this.iamRoleForIdentityCenterApplicationArn = builder.iamRoleForIdentityCenterApplicationArn;
        this.iamIdentityCenterApplicationArn = builder.iamIdentityCenterApplicationArn;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final String iamIdentityCenterInstanceArn() {
        return this.iamIdentityCenterInstanceArn;
    }

    public final String iamRoleForIdentityCenterApplicationArn() {
        return this.iamRoleForIdentityCenterApplicationArn;
    }

    public final String iamIdentityCenterApplicationArn() {
        return this.iamIdentityCenterApplicationArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamIdentityCenterInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleForIdentityCenterApplicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamIdentityCenterApplicationArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IamIdentityCenterOptions)) {
            return false;
        }
        IamIdentityCenterOptions other = (IamIdentityCenterOptions)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.iamIdentityCenterInstanceArn(), other.iamIdentityCenterInstanceArn()) && Objects.equals(this.iamRoleForIdentityCenterApplicationArn(), other.iamRoleForIdentityCenterApplicationArn()) && Objects.equals(this.iamIdentityCenterApplicationArn(), other.iamIdentityCenterApplicationArn());
    }

    public final String toString() {
        return ToString.builder((String)"IamIdentityCenterOptions").add("Enabled", (Object)this.enabled()).add("IamIdentityCenterInstanceArn", (Object)this.iamIdentityCenterInstanceArn()).add("IamRoleForIdentityCenterApplicationArn", (Object)this.iamRoleForIdentityCenterApplicationArn()).add("IamIdentityCenterApplicationArn", (Object)this.iamIdentityCenterApplicationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "iamIdentityCenterInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.iamIdentityCenterInstanceArn()));
            }
            case "iamRoleForIdentityCenterApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleForIdentityCenterApplicationArn()));
            }
            case "iamIdentityCenterApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.iamIdentityCenterApplicationArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("enabled", ENABLED_FIELD);
        map.put("iamIdentityCenterInstanceArn", IAM_IDENTITY_CENTER_INSTANCE_ARN_FIELD);
        map.put("iamRoleForIdentityCenterApplicationArn", IAM_ROLE_FOR_IDENTITY_CENTER_APPLICATION_ARN_FIELD);
        map.put("iamIdentityCenterApplicationArn", IAM_IDENTITY_CENTER_APPLICATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IamIdentityCenterOptions, T> g) {
        return obj -> g.apply((IamIdentityCenterOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String iamIdentityCenterInstanceArn;
        private String iamRoleForIdentityCenterApplicationArn;
        private String iamIdentityCenterApplicationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(IamIdentityCenterOptions model) {
            this.enabled(model.enabled);
            this.iamIdentityCenterInstanceArn(model.iamIdentityCenterInstanceArn);
            this.iamRoleForIdentityCenterApplicationArn(model.iamRoleForIdentityCenterApplicationArn);
            this.iamIdentityCenterApplicationArn(model.iamIdentityCenterApplicationArn);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getIamIdentityCenterInstanceArn() {
            return this.iamIdentityCenterInstanceArn;
        }

        public final void setIamIdentityCenterInstanceArn(String iamIdentityCenterInstanceArn) {
            this.iamIdentityCenterInstanceArn = iamIdentityCenterInstanceArn;
        }

        @Override
        public final Builder iamIdentityCenterInstanceArn(String iamIdentityCenterInstanceArn) {
            this.iamIdentityCenterInstanceArn = iamIdentityCenterInstanceArn;
            return this;
        }

        public final String getIamRoleForIdentityCenterApplicationArn() {
            return this.iamRoleForIdentityCenterApplicationArn;
        }

        public final void setIamRoleForIdentityCenterApplicationArn(String iamRoleForIdentityCenterApplicationArn) {
            this.iamRoleForIdentityCenterApplicationArn = iamRoleForIdentityCenterApplicationArn;
        }

        @Override
        public final Builder iamRoleForIdentityCenterApplicationArn(String iamRoleForIdentityCenterApplicationArn) {
            this.iamRoleForIdentityCenterApplicationArn = iamRoleForIdentityCenterApplicationArn;
            return this;
        }

        public final String getIamIdentityCenterApplicationArn() {
            return this.iamIdentityCenterApplicationArn;
        }

        public final void setIamIdentityCenterApplicationArn(String iamIdentityCenterApplicationArn) {
            this.iamIdentityCenterApplicationArn = iamIdentityCenterApplicationArn;
        }

        @Override
        public final Builder iamIdentityCenterApplicationArn(String iamIdentityCenterApplicationArn) {
            this.iamIdentityCenterApplicationArn = iamIdentityCenterApplicationArn;
            return this;
        }

        public IamIdentityCenterOptions build() {
            return new IamIdentityCenterOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IamIdentityCenterOptions> {
        public Builder enabled(Boolean var1);

        public Builder iamIdentityCenterInstanceArn(String var1);

        public Builder iamRoleForIdentityCenterApplicationArn(String var1);

        public Builder iamIdentityCenterApplicationArn(String var1);
    }
}

