/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.omics.model.Accelerators;
import software.amazon.awssdk.services.omics.model.ContainerRegistryMap;
import software.amazon.awssdk.services.omics.model.DefinitionRepository;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.services.omics.model.StorageType;
import software.amazon.awssdk.services.omics.model.TagMapCopier;
import software.amazon.awssdk.services.omics.model.WorkflowEngine;
import software.amazon.awssdk.services.omics.model.WorkflowParameter;
import software.amazon.awssdk.services.omics.model.WorkflowParameterTemplateCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWorkflowRequest
extends OmicsRequest
implements ToCopyableBuilder<Builder, CreateWorkflowRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::name)).setter(CreateWorkflowRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::description)).setter(CreateWorkflowRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("engine").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::engineAsString)).setter(CreateWorkflowRequest.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engine").build()}).build();
    private static final SdkField<SdkBytes> DEFINITION_ZIP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("definitionZip").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::definitionZip)).setter(CreateWorkflowRequest.setter(Builder::definitionZip)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definitionZip").build()}).build();
    private static final SdkField<String> DEFINITION_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("definitionUri").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::definitionUri)).setter(CreateWorkflowRequest.setter(Builder::definitionUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definitionUri").build()}).build();
    private static final SdkField<String> MAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("main").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::main)).setter(CreateWorkflowRequest.setter(Builder::main)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("main").build()}).build();
    private static final SdkField<Map<String, WorkflowParameter>> PARAMETER_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("parameterTemplate").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::parameterTemplate)).setter(CreateWorkflowRequest.setter(Builder::parameterTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterTemplate").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkflowParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> STORAGE_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("storageCapacity").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::storageCapacity)).setter(CreateWorkflowRequest.setter(Builder::storageCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageCapacity").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::tags)).setter(CreateWorkflowRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestId").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::requestId)).setter(CreateWorkflowRequest.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> ACCELERATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accelerators").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::acceleratorsAsString)).setter(CreateWorkflowRequest.setter(Builder::accelerators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accelerators").build()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storageType").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::storageTypeAsString)).setter(CreateWorkflowRequest.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageType").build()}).build();
    private static final SdkField<ContainerRegistryMap> CONTAINER_REGISTRY_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("containerRegistryMap").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::containerRegistryMap)).setter(CreateWorkflowRequest.setter(Builder::containerRegistryMap)).constructor(ContainerRegistryMap::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerRegistryMap").build()}).build();
    private static final SdkField<String> CONTAINER_REGISTRY_MAP_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerRegistryMapUri").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::containerRegistryMapUri)).setter(CreateWorkflowRequest.setter(Builder::containerRegistryMapUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerRegistryMapUri").build()}).build();
    private static final SdkField<String> README_MARKDOWN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("readmeMarkdown").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::readmeMarkdown)).setter(CreateWorkflowRequest.setter(Builder::readmeMarkdown)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readmeMarkdown").build()}).build();
    private static final SdkField<String> PARAMETER_TEMPLATE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parameterTemplatePath").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::parameterTemplatePath)).setter(CreateWorkflowRequest.setter(Builder::parameterTemplatePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterTemplatePath").build()}).build();
    private static final SdkField<String> README_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("readmePath").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::readmePath)).setter(CreateWorkflowRequest.setter(Builder::readmePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readmePath").build()}).build();
    private static final SdkField<DefinitionRepository> DEFINITION_REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("definitionRepository").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::definitionRepository)).setter(CreateWorkflowRequest.setter(Builder::definitionRepository)).constructor(DefinitionRepository::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definitionRepository").build()}).build();
    private static final SdkField<String> WORKFLOW_BUCKET_OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowBucketOwnerId").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::workflowBucketOwnerId)).setter(CreateWorkflowRequest.setter(Builder::workflowBucketOwnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowBucketOwnerId").build()}).build();
    private static final SdkField<String> README_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("readmeUri").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::readmeUri)).setter(CreateWorkflowRequest.setter(Builder::readmeUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readmeUri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, ENGINE_FIELD, DEFINITION_ZIP_FIELD, DEFINITION_URI_FIELD, MAIN_FIELD, PARAMETER_TEMPLATE_FIELD, STORAGE_CAPACITY_FIELD, TAGS_FIELD, REQUEST_ID_FIELD, ACCELERATORS_FIELD, STORAGE_TYPE_FIELD, CONTAINER_REGISTRY_MAP_FIELD, CONTAINER_REGISTRY_MAP_URI_FIELD, README_MARKDOWN_FIELD, PARAMETER_TEMPLATE_PATH_FIELD, README_PATH_FIELD, DEFINITION_REPOSITORY_FIELD, WORKFLOW_BUCKET_OWNER_ID_FIELD, README_URI_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateWorkflowRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final String engine;
    private final SdkBytes definitionZip;
    private final String definitionUri;
    private final String main;
    private final Map<String, WorkflowParameter> parameterTemplate;
    private final Integer storageCapacity;
    private final Map<String, String> tags;
    private final String requestIdValue;
    private final String accelerators;
    private final String storageType;
    private final ContainerRegistryMap containerRegistryMap;
    private final String containerRegistryMapUri;
    private final String readmeMarkdown;
    private final String parameterTemplatePath;
    private final String readmePath;
    private final DefinitionRepository definitionRepository;
    private final String workflowBucketOwnerId;
    private final String readmeUri;

    private CreateWorkflowRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.engine = builder.engine;
        this.definitionZip = builder.definitionZip;
        this.definitionUri = builder.definitionUri;
        this.main = builder.main;
        this.parameterTemplate = builder.parameterTemplate;
        this.storageCapacity = builder.storageCapacity;
        this.tags = builder.tags;
        this.requestIdValue = builder.requestIdValue;
        this.accelerators = builder.accelerators;
        this.storageType = builder.storageType;
        this.containerRegistryMap = builder.containerRegistryMap;
        this.containerRegistryMapUri = builder.containerRegistryMapUri;
        this.readmeMarkdown = builder.readmeMarkdown;
        this.parameterTemplatePath = builder.parameterTemplatePath;
        this.readmePath = builder.readmePath;
        this.definitionRepository = builder.definitionRepository;
        this.workflowBucketOwnerId = builder.workflowBucketOwnerId;
        this.readmeUri = builder.readmeUri;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final WorkflowEngine engine() {
        return WorkflowEngine.fromValue(this.engine);
    }

    public final String engineAsString() {
        return this.engine;
    }

    public final SdkBytes definitionZip() {
        return this.definitionZip;
    }

    public final String definitionUri() {
        return this.definitionUri;
    }

    public final String main() {
        return this.main;
    }

    public final boolean hasParameterTemplate() {
        return this.parameterTemplate != null && !(this.parameterTemplate instanceof SdkAutoConstructMap);
    }

    public final Map<String, WorkflowParameter> parameterTemplate() {
        return this.parameterTemplate;
    }

    public final Integer storageCapacity() {
        return this.storageCapacity;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String requestId() {
        return this.requestIdValue;
    }

    public final Accelerators accelerators() {
        return Accelerators.fromValue(this.accelerators);
    }

    public final String acceleratorsAsString() {
        return this.accelerators;
    }

    public final StorageType storageType() {
        return StorageType.fromValue(this.storageType);
    }

    public final String storageTypeAsString() {
        return this.storageType;
    }

    public final ContainerRegistryMap containerRegistryMap() {
        return this.containerRegistryMap;
    }

    public final String containerRegistryMapUri() {
        return this.containerRegistryMapUri;
    }

    public final String readmeMarkdown() {
        return this.readmeMarkdown;
    }

    public final String parameterTemplatePath() {
        return this.parameterTemplatePath;
    }

    public final String readmePath() {
        return this.readmePath;
    }

    public final DefinitionRepository definitionRepository() {
        return this.definitionRepository;
    }

    public final String workflowBucketOwnerId() {
        return this.workflowBucketOwnerId;
    }

    public final String readmeUri() {
        return this.readmeUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.definitionZip());
        hashCode = 31 * hashCode + Objects.hashCode(this.definitionUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.main());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameterTemplate() ? this.parameterTemplate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.storageCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceleratorsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerRegistryMap());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerRegistryMapUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.readmeMarkdown());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterTemplatePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.readmePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.definitionRepository());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowBucketOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.readmeUri());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkflowRequest)) {
            return false;
        }
        CreateWorkflowRequest other = (CreateWorkflowRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.engineAsString(), other.engineAsString()) && Objects.equals(this.definitionZip(), other.definitionZip()) && Objects.equals(this.definitionUri(), other.definitionUri()) && Objects.equals(this.main(), other.main()) && this.hasParameterTemplate() == other.hasParameterTemplate() && Objects.equals(this.parameterTemplate(), other.parameterTemplate()) && Objects.equals(this.storageCapacity(), other.storageCapacity()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.acceleratorsAsString(), other.acceleratorsAsString()) && Objects.equals(this.storageTypeAsString(), other.storageTypeAsString()) && Objects.equals(this.containerRegistryMap(), other.containerRegistryMap()) && Objects.equals(this.containerRegistryMapUri(), other.containerRegistryMapUri()) && Objects.equals(this.readmeMarkdown(), other.readmeMarkdown()) && Objects.equals(this.parameterTemplatePath(), other.parameterTemplatePath()) && Objects.equals(this.readmePath(), other.readmePath()) && Objects.equals(this.definitionRepository(), other.definitionRepository()) && Objects.equals(this.workflowBucketOwnerId(), other.workflowBucketOwnerId()) && Objects.equals(this.readmeUri(), other.readmeUri());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWorkflowRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Engine", (Object)this.engineAsString()).add("DefinitionZip", (Object)this.definitionZip()).add("DefinitionUri", (Object)this.definitionUri()).add("Main", (Object)this.main()).add("ParameterTemplate", this.hasParameterTemplate() ? this.parameterTemplate() : null).add("StorageCapacity", (Object)this.storageCapacity()).add("Tags", this.hasTags() ? this.tags() : null).add("RequestId", (Object)this.requestId()).add("Accelerators", (Object)this.acceleratorsAsString()).add("StorageType", (Object)this.storageTypeAsString()).add("ContainerRegistryMap", (Object)this.containerRegistryMap()).add("ContainerRegistryMapUri", (Object)this.containerRegistryMapUri()).add("ReadmeMarkdown", (Object)this.readmeMarkdown()).add("ParameterTemplatePath", (Object)this.parameterTemplatePath()).add("ReadmePath", (Object)this.readmePath()).add("DefinitionRepository", (Object)this.definitionRepository()).add("WorkflowBucketOwnerId", (Object)this.workflowBucketOwnerId()).add("ReadmeUri", (Object)this.readmeUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "engine": {
                return Optional.ofNullable(clazz.cast(this.engineAsString()));
            }
            case "definitionZip": {
                return Optional.ofNullable(clazz.cast(this.definitionZip()));
            }
            case "definitionUri": {
                return Optional.ofNullable(clazz.cast(this.definitionUri()));
            }
            case "main": {
                return Optional.ofNullable(clazz.cast(this.main()));
            }
            case "parameterTemplate": {
                return Optional.ofNullable(clazz.cast(this.parameterTemplate()));
            }
            case "storageCapacity": {
                return Optional.ofNullable(clazz.cast(this.storageCapacity()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "accelerators": {
                return Optional.ofNullable(clazz.cast(this.acceleratorsAsString()));
            }
            case "storageType": {
                return Optional.ofNullable(clazz.cast(this.storageTypeAsString()));
            }
            case "containerRegistryMap": {
                return Optional.ofNullable(clazz.cast(this.containerRegistryMap()));
            }
            case "containerRegistryMapUri": {
                return Optional.ofNullable(clazz.cast(this.containerRegistryMapUri()));
            }
            case "readmeMarkdown": {
                return Optional.ofNullable(clazz.cast(this.readmeMarkdown()));
            }
            case "parameterTemplatePath": {
                return Optional.ofNullable(clazz.cast(this.parameterTemplatePath()));
            }
            case "readmePath": {
                return Optional.ofNullable(clazz.cast(this.readmePath()));
            }
            case "definitionRepository": {
                return Optional.ofNullable(clazz.cast(this.definitionRepository()));
            }
            case "workflowBucketOwnerId": {
                return Optional.ofNullable(clazz.cast(this.workflowBucketOwnerId()));
            }
            case "readmeUri": {
                return Optional.ofNullable(clazz.cast(this.readmeUri()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("engine", ENGINE_FIELD);
        map.put("definitionZip", DEFINITION_ZIP_FIELD);
        map.put("definitionUri", DEFINITION_URI_FIELD);
        map.put("main", MAIN_FIELD);
        map.put("parameterTemplate", PARAMETER_TEMPLATE_FIELD);
        map.put("storageCapacity", STORAGE_CAPACITY_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("requestId", REQUEST_ID_FIELD);
        map.put("accelerators", ACCELERATORS_FIELD);
        map.put("storageType", STORAGE_TYPE_FIELD);
        map.put("containerRegistryMap", CONTAINER_REGISTRY_MAP_FIELD);
        map.put("containerRegistryMapUri", CONTAINER_REGISTRY_MAP_URI_FIELD);
        map.put("readmeMarkdown", README_MARKDOWN_FIELD);
        map.put("parameterTemplatePath", PARAMETER_TEMPLATE_PATH_FIELD);
        map.put("readmePath", README_PATH_FIELD);
        map.put("definitionRepository", DEFINITION_REPOSITORY_FIELD);
        map.put("workflowBucketOwnerId", WORKFLOW_BUCKET_OWNER_ID_FIELD);
        map.put("readmeUri", README_URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkflowRequest, T> g) {
        return obj -> g.apply((CreateWorkflowRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String engine;
        private SdkBytes definitionZip;
        private String definitionUri;
        private String main;
        private Map<String, WorkflowParameter> parameterTemplate = DefaultSdkAutoConstructMap.getInstance();
        private Integer storageCapacity;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String requestIdValue;
        private String accelerators;
        private String storageType;
        private ContainerRegistryMap containerRegistryMap;
        private String containerRegistryMapUri;
        private String readmeMarkdown;
        private String parameterTemplatePath;
        private String readmePath;
        private DefinitionRepository definitionRepository;
        private String workflowBucketOwnerId;
        private String readmeUri;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkflowRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.engine(model.engine);
            this.definitionZip(model.definitionZip);
            this.definitionUri(model.definitionUri);
            this.main(model.main);
            this.parameterTemplate(model.parameterTemplate);
            this.storageCapacity(model.storageCapacity);
            this.tags(model.tags);
            this.requestId(model.requestIdValue);
            this.accelerators(model.accelerators);
            this.storageType(model.storageType);
            this.containerRegistryMap(model.containerRegistryMap);
            this.containerRegistryMapUri(model.containerRegistryMapUri);
            this.readmeMarkdown(model.readmeMarkdown);
            this.parameterTemplatePath(model.parameterTemplatePath);
            this.readmePath(model.readmePath);
            this.definitionRepository(model.definitionRepository);
            this.workflowBucketOwnerId(model.workflowBucketOwnerId);
            this.readmeUri(model.readmeUri);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        @Override
        public final Builder engine(WorkflowEngine engine) {
            this.engine(engine == null ? null : engine.toString());
            return this;
        }

        public final ByteBuffer getDefinitionZip() {
            return this.definitionZip == null ? null : this.definitionZip.asByteBuffer();
        }

        public final void setDefinitionZip(ByteBuffer definitionZip) {
            this.definitionZip(definitionZip == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)definitionZip));
        }

        @Override
        public final Builder definitionZip(SdkBytes definitionZip) {
            this.definitionZip = definitionZip;
            return this;
        }

        public final String getDefinitionUri() {
            return this.definitionUri;
        }

        public final void setDefinitionUri(String definitionUri) {
            this.definitionUri = definitionUri;
        }

        @Override
        public final Builder definitionUri(String definitionUri) {
            this.definitionUri = definitionUri;
            return this;
        }

        public final String getMain() {
            return this.main;
        }

        public final void setMain(String main) {
            this.main = main;
        }

        @Override
        public final Builder main(String main) {
            this.main = main;
            return this;
        }

        public final Map<String, WorkflowParameter.Builder> getParameterTemplate() {
            Map<String, WorkflowParameter.Builder> result = WorkflowParameterTemplateCopier.copyToBuilder(this.parameterTemplate);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameterTemplate(Map<String, WorkflowParameter.BuilderImpl> parameterTemplate) {
            this.parameterTemplate = WorkflowParameterTemplateCopier.copyFromBuilder(parameterTemplate);
        }

        @Override
        public final Builder parameterTemplate(Map<String, WorkflowParameter> parameterTemplate) {
            this.parameterTemplate = WorkflowParameterTemplateCopier.copy(parameterTemplate);
            return this;
        }

        public final Integer getStorageCapacity() {
            return this.storageCapacity;
        }

        public final void setStorageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
        }

        @Override
        public final Builder storageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final String getAccelerators() {
            return this.accelerators;
        }

        public final void setAccelerators(String accelerators) {
            this.accelerators = accelerators;
        }

        @Override
        public final Builder accelerators(String accelerators) {
            this.accelerators = accelerators;
            return this;
        }

        @Override
        public final Builder accelerators(Accelerators accelerators) {
            this.accelerators(accelerators == null ? null : accelerators.toString());
            return this;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public final Builder storageType(StorageType storageType) {
            this.storageType(storageType == null ? null : storageType.toString());
            return this;
        }

        public final ContainerRegistryMap.Builder getContainerRegistryMap() {
            return this.containerRegistryMap != null ? this.containerRegistryMap.toBuilder() : null;
        }

        public final void setContainerRegistryMap(ContainerRegistryMap.BuilderImpl containerRegistryMap) {
            this.containerRegistryMap = containerRegistryMap != null ? containerRegistryMap.build() : null;
        }

        @Override
        public final Builder containerRegistryMap(ContainerRegistryMap containerRegistryMap) {
            this.containerRegistryMap = containerRegistryMap;
            return this;
        }

        public final String getContainerRegistryMapUri() {
            return this.containerRegistryMapUri;
        }

        public final void setContainerRegistryMapUri(String containerRegistryMapUri) {
            this.containerRegistryMapUri = containerRegistryMapUri;
        }

        @Override
        public final Builder containerRegistryMapUri(String containerRegistryMapUri) {
            this.containerRegistryMapUri = containerRegistryMapUri;
            return this;
        }

        public final String getReadmeMarkdown() {
            return this.readmeMarkdown;
        }

        public final void setReadmeMarkdown(String readmeMarkdown) {
            this.readmeMarkdown = readmeMarkdown;
        }

        @Override
        public final Builder readmeMarkdown(String readmeMarkdown) {
            this.readmeMarkdown = readmeMarkdown;
            return this;
        }

        public final String getParameterTemplatePath() {
            return this.parameterTemplatePath;
        }

        public final void setParameterTemplatePath(String parameterTemplatePath) {
            this.parameterTemplatePath = parameterTemplatePath;
        }

        @Override
        public final Builder parameterTemplatePath(String parameterTemplatePath) {
            this.parameterTemplatePath = parameterTemplatePath;
            return this;
        }

        public final String getReadmePath() {
            return this.readmePath;
        }

        public final void setReadmePath(String readmePath) {
            this.readmePath = readmePath;
        }

        @Override
        public final Builder readmePath(String readmePath) {
            this.readmePath = readmePath;
            return this;
        }

        public final DefinitionRepository.Builder getDefinitionRepository() {
            return this.definitionRepository != null ? this.definitionRepository.toBuilder() : null;
        }

        public final void setDefinitionRepository(DefinitionRepository.BuilderImpl definitionRepository) {
            this.definitionRepository = definitionRepository != null ? definitionRepository.build() : null;
        }

        @Override
        public final Builder definitionRepository(DefinitionRepository definitionRepository) {
            this.definitionRepository = definitionRepository;
            return this;
        }

        public final String getWorkflowBucketOwnerId() {
            return this.workflowBucketOwnerId;
        }

        public final void setWorkflowBucketOwnerId(String workflowBucketOwnerId) {
            this.workflowBucketOwnerId = workflowBucketOwnerId;
        }

        @Override
        public final Builder workflowBucketOwnerId(String workflowBucketOwnerId) {
            this.workflowBucketOwnerId = workflowBucketOwnerId;
            return this;
        }

        public final String getReadmeUri() {
            return this.readmeUri;
        }

        public final void setReadmeUri(String readmeUri) {
            this.readmeUri = readmeUri;
        }

        @Override
        public final Builder readmeUri(String readmeUri) {
            this.readmeUri = readmeUri;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkflowRequest build() {
            return new CreateWorkflowRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OmicsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWorkflowRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder engine(String var1);

        public Builder engine(WorkflowEngine var1);

        public Builder definitionZip(SdkBytes var1);

        public Builder definitionUri(String var1);

        public Builder main(String var1);

        public Builder parameterTemplate(Map<String, WorkflowParameter> var1);

        public Builder storageCapacity(Integer var1);

        public Builder tags(Map<String, String> var1);

        public Builder requestId(String var1);

        public Builder accelerators(String var1);

        public Builder accelerators(Accelerators var1);

        public Builder storageType(String var1);

        public Builder storageType(StorageType var1);

        public Builder containerRegistryMap(ContainerRegistryMap var1);

        default public Builder containerRegistryMap(Consumer<ContainerRegistryMap.Builder> containerRegistryMap) {
            return this.containerRegistryMap((ContainerRegistryMap)((ContainerRegistryMap.Builder)ContainerRegistryMap.builder().applyMutation(containerRegistryMap)).build());
        }

        public Builder containerRegistryMapUri(String var1);

        public Builder readmeMarkdown(String var1);

        public Builder parameterTemplatePath(String var1);

        public Builder readmePath(String var1);

        public Builder definitionRepository(DefinitionRepository var1);

        default public Builder definitionRepository(Consumer<DefinitionRepository.Builder> definitionRepository) {
            return this.definitionRepository((DefinitionRepository)((DefinitionRepository.Builder)DefinitionRepository.builder().applyMutation(definitionRepository)).build());
        }

        public Builder workflowBucketOwnerId(String var1);

        public Builder readmeUri(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

