/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsClient;
import software.amazon.awssdk.services.omics.internal.UserAgentUtils;
import software.amazon.awssdk.services.omics.model.ListSequenceStoresRequest;
import software.amazon.awssdk.services.omics.model.ListSequenceStoresResponse;
import software.amazon.awssdk.services.omics.model.SequenceStoreDetail;

public class ListSequenceStoresIterable
implements SdkIterable<ListSequenceStoresResponse> {
    private final OmicsClient client;
    private final ListSequenceStoresRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSequenceStoresIterable(OmicsClient client, ListSequenceStoresRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSequenceStoresResponseFetcher();
    }

    public Iterator<ListSequenceStoresResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SequenceStoreDetail> sequenceStores() {
        Function<ListSequenceStoresResponse, Iterator> getIterator = response -> {
            if (response != null && response.sequenceStores() != null) {
                return response.sequenceStores().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSequenceStoresResponseFetcher
    implements SyncPageFetcher<ListSequenceStoresResponse> {
        private ListSequenceStoresResponseFetcher() {
        }

        public boolean hasNextPage(ListSequenceStoresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSequenceStoresResponse nextPage(ListSequenceStoresResponse previousPage) {
            if (previousPage == null) {
                return ListSequenceStoresIterable.this.client.listSequenceStores(ListSequenceStoresIterable.this.firstRequest);
            }
            return ListSequenceStoresIterable.this.client.listSequenceStores((ListSequenceStoresRequest)((Object)ListSequenceStoresIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

