/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsClient;
import software.amazon.awssdk.services.omics.internal.UserAgentUtils;
import software.amazon.awssdk.services.omics.model.ListRunGroupsRequest;
import software.amazon.awssdk.services.omics.model.ListRunGroupsResponse;
import software.amazon.awssdk.services.omics.model.RunGroupListItem;

public class ListRunGroupsIterable
implements SdkIterable<ListRunGroupsResponse> {
    private final OmicsClient client;
    private final ListRunGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRunGroupsIterable(OmicsClient client, ListRunGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRunGroupsResponseFetcher();
    }

    public Iterator<ListRunGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RunGroupListItem> items() {
        Function<ListRunGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRunGroupsResponseFetcher
    implements SyncPageFetcher<ListRunGroupsResponse> {
        private ListRunGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListRunGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRunGroupsResponse nextPage(ListRunGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListRunGroupsIterable.this.client.listRunGroups(ListRunGroupsIterable.this.firstRequest);
            }
            return ListRunGroupsIterable.this.client.listRunGroups((ListRunGroupsRequest)((Object)ListRunGroupsIterable.this.firstRequest.toBuilder().startingToken(previousPage.nextToken()).build()));
        }
    }
}

