/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsClient;
import software.amazon.awssdk.services.omics.internal.UserAgentUtils;
import software.amazon.awssdk.services.omics.model.ListRunCachesRequest;
import software.amazon.awssdk.services.omics.model.ListRunCachesResponse;
import software.amazon.awssdk.services.omics.model.RunCacheListItem;

public class ListRunCachesIterable
implements SdkIterable<ListRunCachesResponse> {
    private final OmicsClient client;
    private final ListRunCachesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRunCachesIterable(OmicsClient client, ListRunCachesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRunCachesResponseFetcher();
    }

    public Iterator<ListRunCachesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RunCacheListItem> items() {
        Function<ListRunCachesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRunCachesResponseFetcher
    implements SyncPageFetcher<ListRunCachesResponse> {
        private ListRunCachesResponseFetcher() {
        }

        public boolean hasNextPage(ListRunCachesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRunCachesResponse nextPage(ListRunCachesResponse previousPage) {
            if (previousPage == null) {
                return ListRunCachesIterable.this.client.listRunCaches(ListRunCachesIterable.this.firstRequest);
            }
            return ListRunCachesIterable.this.client.listRunCaches((ListRunCachesRequest)((Object)ListRunCachesIterable.this.firstRequest.toBuilder().startingToken(previousPage.nextToken()).build()));
        }
    }
}

