/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SchemaValueType {
    LONG("LONG"),
    INT("INT"),
    STRING("STRING"),
    FLOAT("FLOAT"),
    DOUBLE("DOUBLE"),
    BOOLEAN("BOOLEAN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SchemaValueType> VALUE_MAP;
    private final String value;

    private SchemaValueType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SchemaValueType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SchemaValueType> knownValues() {
        EnumSet<SchemaValueType> knownValues = EnumSet.allOf(SchemaValueType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SchemaValueType.class, SchemaValueType::toString);
    }
}

