/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.omics.model.ImportReferenceJobItem;
import software.amazon.awssdk.services.omics.model.ImportReferenceJobListCopier;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListReferenceImportJobsResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, ListReferenceImportJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListReferenceImportJobsResponse.getter(ListReferenceImportJobsResponse::nextToken)).setter(ListReferenceImportJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ImportReferenceJobItem>> IMPORT_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("importJobs").getter(ListReferenceImportJobsResponse.getter(ListReferenceImportJobsResponse::importJobs)).setter(ListReferenceImportJobsResponse.setter(Builder::importJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImportReferenceJobItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, IMPORT_JOBS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListReferenceImportJobsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ImportReferenceJobItem> importJobs;

    private ListReferenceImportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.importJobs = builder.importJobs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasImportJobs() {
        return this.importJobs != null && !(this.importJobs instanceof SdkAutoConstructList);
    }

    public final List<ImportReferenceJobItem> importJobs() {
        return this.importJobs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImportJobs() ? this.importJobs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReferenceImportJobsResponse)) {
            return false;
        }
        ListReferenceImportJobsResponse other = (ListReferenceImportJobsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasImportJobs() == other.hasImportJobs() && Objects.equals(this.importJobs(), other.importJobs());
    }

    public final String toString() {
        return ToString.builder((String)"ListReferenceImportJobsResponse").add("NextToken", (Object)this.nextToken()).add("ImportJobs", this.hasImportJobs() ? this.importJobs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "importJobs": {
                return Optional.ofNullable(clazz.cast(this.importJobs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("importJobs", IMPORT_JOBS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListReferenceImportJobsResponse, T> g) {
        return obj -> g.apply((ListReferenceImportJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ImportReferenceJobItem> importJobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListReferenceImportJobsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.importJobs(model.importJobs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ImportReferenceJobItem.Builder> getImportJobs() {
            List<ImportReferenceJobItem.Builder> result = ImportReferenceJobListCopier.copyToBuilder(this.importJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImportJobs(Collection<ImportReferenceJobItem.BuilderImpl> importJobs) {
            this.importJobs = ImportReferenceJobListCopier.copyFromBuilder(importJobs);
        }

        @Override
        public final Builder importJobs(Collection<ImportReferenceJobItem> importJobs) {
            this.importJobs = ImportReferenceJobListCopier.copy(importJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importJobs(ImportReferenceJobItem ... importJobs) {
            this.importJobs(Arrays.asList(importJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importJobs(Consumer<ImportReferenceJobItem.Builder> ... importJobs) {
            this.importJobs(Stream.of(importJobs).map(c -> (ImportReferenceJobItem)((ImportReferenceJobItem.Builder)ImportReferenceJobItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListReferenceImportJobsResponse build() {
            return new ListReferenceImportJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListReferenceImportJobsResponse> {
        public Builder nextToken(String var1);

        public Builder importJobs(Collection<ImportReferenceJobItem> var1);

        public Builder importJobs(ImportReferenceJobItem ... var1);

        public Builder importJobs(Consumer<ImportReferenceJobItem.Builder> ... var1);
    }
}

