/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.services.omics.model.ShareStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateShareResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, CreateShareResponse> {
    private static final SdkField<String> SHARE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("shareId").getter(CreateShareResponse.getter(CreateShareResponse::shareId)).setter(CreateShareResponse.setter(Builder::shareId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shareId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateShareResponse.getter(CreateShareResponse::statusAsString)).setter(CreateShareResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> SHARE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("shareName").getter(CreateShareResponse.getter(CreateShareResponse::shareName)).setter(CreateShareResponse.setter(Builder::shareName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shareName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARE_ID_FIELD, STATUS_FIELD, SHARE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateShareResponse.memberNameToFieldInitializer();
    private final String shareId;
    private final String status;
    private final String shareName;

    private CreateShareResponse(BuilderImpl builder) {
        super(builder);
        this.shareId = builder.shareId;
        this.status = builder.status;
        this.shareName = builder.shareName;
    }

    public final String shareId() {
        return this.shareId;
    }

    public final ShareStatus status() {
        return ShareStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String shareName() {
        return this.shareName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.shareId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateShareResponse)) {
            return false;
        }
        CreateShareResponse other = (CreateShareResponse)((Object)obj);
        return Objects.equals(this.shareId(), other.shareId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.shareName(), other.shareName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateShareResponse").add("ShareId", (Object)this.shareId()).add("Status", (Object)this.statusAsString()).add("ShareName", (Object)this.shareName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "shareId": {
                return Optional.ofNullable(clazz.cast(this.shareId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "shareName": {
                return Optional.ofNullable(clazz.cast(this.shareName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("shareId", SHARE_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("shareName", SHARE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateShareResponse, T> g) {
        return obj -> g.apply((CreateShareResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private String shareId;
        private String status;
        private String shareName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateShareResponse model) {
            super(model);
            this.shareId(model.shareId);
            this.status(model.status);
            this.shareName(model.shareName);
        }

        public final String getShareId() {
            return this.shareId;
        }

        public final void setShareId(String shareId) {
            this.shareId = shareId;
        }

        @Override
        public final Builder shareId(String shareId) {
            this.shareId = shareId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ShareStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getShareName() {
            return this.shareName;
        }

        public final void setShareName(String shareName) {
            this.shareName = shareName;
        }

        @Override
        public final Builder shareName(String shareName) {
            this.shareName = shareName;
            return this;
        }

        @Override
        public CreateShareResponse build() {
            return new CreateShareResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateShareResponse> {
        public Builder shareId(String var1);

        public Builder status(String var1);

        public Builder status(ShareStatus var1);

        public Builder shareName(String var1);
    }
}

