/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsAsyncClient;
import software.amazon.awssdk.services.omics.internal.UserAgentUtils;
import software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsRequest;
import software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsResponse;
import software.amazon.awssdk.services.omics.model.MultipartReadSetUploadListItem;

public class ListMultipartReadSetUploadsPublisher
implements SdkPublisher<ListMultipartReadSetUploadsResponse> {
    private final OmicsAsyncClient client;
    private final ListMultipartReadSetUploadsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMultipartReadSetUploadsPublisher(OmicsAsyncClient client, ListMultipartReadSetUploadsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMultipartReadSetUploadsPublisher(OmicsAsyncClient client, ListMultipartReadSetUploadsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMultipartReadSetUploadsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMultipartReadSetUploadsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MultipartReadSetUploadListItem> uploads() {
        Function<ListMultipartReadSetUploadsResponse, Iterator> getIterator = response -> {
            if (response != null && response.uploads() != null) {
                return response.uploads().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMultipartReadSetUploadsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMultipartReadSetUploadsResponseFetcher
    implements AsyncPageFetcher<ListMultipartReadSetUploadsResponse> {
        private ListMultipartReadSetUploadsResponseFetcher() {
        }

        public boolean hasNextPage(ListMultipartReadSetUploadsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMultipartReadSetUploadsResponse> nextPage(ListMultipartReadSetUploadsResponse previousPage) {
            if (previousPage == null) {
                return ListMultipartReadSetUploadsPublisher.this.client.listMultipartReadSetUploads(ListMultipartReadSetUploadsPublisher.this.firstRequest);
            }
            return ListMultipartReadSetUploadsPublisher.this.client.listMultipartReadSetUploads((ListMultipartReadSetUploadsRequest)((Object)ListMultipartReadSetUploadsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

