/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsClient;
import software.amazon.awssdk.services.omics.internal.UserAgentUtils;
import software.amazon.awssdk.services.omics.model.AnnotationStoreItem;
import software.amazon.awssdk.services.omics.model.ListAnnotationStoresRequest;
import software.amazon.awssdk.services.omics.model.ListAnnotationStoresResponse;

public class ListAnnotationStoresIterable
implements SdkIterable<ListAnnotationStoresResponse> {
    private final OmicsClient client;
    private final ListAnnotationStoresRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAnnotationStoresIterable(OmicsClient client, ListAnnotationStoresRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAnnotationStoresResponseFetcher();
    }

    public Iterator<ListAnnotationStoresResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AnnotationStoreItem> annotationStores() {
        Function<ListAnnotationStoresResponse, Iterator> getIterator = response -> {
            if (response != null && response.annotationStores() != null) {
                return response.annotationStores().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAnnotationStoresResponseFetcher
    implements SyncPageFetcher<ListAnnotationStoresResponse> {
        private ListAnnotationStoresResponseFetcher() {
        }

        public boolean hasNextPage(ListAnnotationStoresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAnnotationStoresResponse nextPage(ListAnnotationStoresResponse previousPage) {
            if (previousPage == null) {
                return ListAnnotationStoresIterable.this.client.listAnnotationStores(ListAnnotationStoresIterable.this.firstRequest);
            }
            return ListAnnotationStoresIterable.this.client.listAnnotationStores((ListAnnotationStoresRequest)((Object)ListAnnotationStoresIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

