/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StoreType {
    SEQUENCE_STORE("SEQUENCE_STORE"),
    REFERENCE_STORE("REFERENCE_STORE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StoreType> VALUE_MAP;
    private final String value;

    private StoreType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StoreType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StoreType> knownValues() {
        EnumSet<StoreType> knownValues = EnumSet.allOf(StoreType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StoreType.class, StoreType::toString);
    }
}

