/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.omics.model.AnnotationStoreItem;
import software.amazon.awssdk.services.omics.model.AnnotationStoreItemsCopier;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAnnotationStoresResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, ListAnnotationStoresResponse> {
    private static final SdkField<List<AnnotationStoreItem>> ANNOTATION_STORES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("annotationStores").getter(ListAnnotationStoresResponse.getter(ListAnnotationStoresResponse::annotationStores)).setter(ListAnnotationStoresResponse.setter(Builder::annotationStores)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("annotationStores").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnnotationStoreItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAnnotationStoresResponse.getter(ListAnnotationStoresResponse::nextToken)).setter(ListAnnotationStoresResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANNOTATION_STORES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAnnotationStoresResponse.memberNameToFieldInitializer();
    private final List<AnnotationStoreItem> annotationStores;
    private final String nextToken;

    private ListAnnotationStoresResponse(BuilderImpl builder) {
        super(builder);
        this.annotationStores = builder.annotationStores;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAnnotationStores() {
        return this.annotationStores != null && !(this.annotationStores instanceof SdkAutoConstructList);
    }

    public final List<AnnotationStoreItem> annotationStores() {
        return this.annotationStores;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnnotationStores() ? this.annotationStores() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnnotationStoresResponse)) {
            return false;
        }
        ListAnnotationStoresResponse other = (ListAnnotationStoresResponse)((Object)obj);
        return this.hasAnnotationStores() == other.hasAnnotationStores() && Objects.equals(this.annotationStores(), other.annotationStores()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAnnotationStoresResponse").add("AnnotationStores", this.hasAnnotationStores() ? this.annotationStores() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "annotationStores": {
                return Optional.ofNullable(clazz.cast(this.annotationStores()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("annotationStores", ANNOTATION_STORES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAnnotationStoresResponse, T> g) {
        return obj -> g.apply((ListAnnotationStoresResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private List<AnnotationStoreItem> annotationStores = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnnotationStoresResponse model) {
            super(model);
            this.annotationStores(model.annotationStores);
            this.nextToken(model.nextToken);
        }

        public final List<AnnotationStoreItem.Builder> getAnnotationStores() {
            List<AnnotationStoreItem.Builder> result = AnnotationStoreItemsCopier.copyToBuilder(this.annotationStores);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnnotationStores(Collection<AnnotationStoreItem.BuilderImpl> annotationStores) {
            this.annotationStores = AnnotationStoreItemsCopier.copyFromBuilder(annotationStores);
        }

        @Override
        public final Builder annotationStores(Collection<AnnotationStoreItem> annotationStores) {
            this.annotationStores = AnnotationStoreItemsCopier.copy(annotationStores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder annotationStores(AnnotationStoreItem ... annotationStores) {
            this.annotationStores(Arrays.asList(annotationStores));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder annotationStores(Consumer<AnnotationStoreItem.Builder> ... annotationStores) {
            this.annotationStores(Stream.of(annotationStores).map(c -> (AnnotationStoreItem)((AnnotationStoreItem.Builder)AnnotationStoreItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAnnotationStoresResponse build() {
            return new ListAnnotationStoresResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAnnotationStoresResponse> {
        public Builder annotationStores(Collection<AnnotationStoreItem> var1);

        public Builder annotationStores(AnnotationStoreItem ... var1);

        public Builder annotationStores(Consumer<AnnotationStoreItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

