/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.odb.OdbAsyncClient;
import software.amazon.awssdk.services.odb.internal.UserAgentUtils;
import software.amazon.awssdk.services.odb.model.CloudExadataInfrastructureSummary;
import software.amazon.awssdk.services.odb.model.ListCloudExadataInfrastructuresRequest;
import software.amazon.awssdk.services.odb.model.ListCloudExadataInfrastructuresResponse;

public class ListCloudExadataInfrastructuresPublisher
implements SdkPublisher<ListCloudExadataInfrastructuresResponse> {
    private final OdbAsyncClient client;
    private final ListCloudExadataInfrastructuresRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCloudExadataInfrastructuresPublisher(OdbAsyncClient client, ListCloudExadataInfrastructuresRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCloudExadataInfrastructuresPublisher(OdbAsyncClient client, ListCloudExadataInfrastructuresRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCloudExadataInfrastructuresResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCloudExadataInfrastructuresResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CloudExadataInfrastructureSummary> cloudExadataInfrastructures() {
        Function<ListCloudExadataInfrastructuresResponse, Iterator> getIterator = response -> {
            if (response != null && response.cloudExadataInfrastructures() != null) {
                return response.cloudExadataInfrastructures().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCloudExadataInfrastructuresResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCloudExadataInfrastructuresResponseFetcher
    implements AsyncPageFetcher<ListCloudExadataInfrastructuresResponse> {
        private ListCloudExadataInfrastructuresResponseFetcher() {
        }

        public boolean hasNextPage(ListCloudExadataInfrastructuresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCloudExadataInfrastructuresResponse> nextPage(ListCloudExadataInfrastructuresResponse previousPage) {
            if (previousPage == null) {
                return ListCloudExadataInfrastructuresPublisher.this.client.listCloudExadataInfrastructures(ListCloudExadataInfrastructuresPublisher.this.firstRequest);
            }
            return ListCloudExadataInfrastructuresPublisher.this.client.listCloudExadataInfrastructures((ListCloudExadataInfrastructuresRequest)((Object)ListCloudExadataInfrastructuresPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

