/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.odb.model.Access;
import software.amazon.awssdk.services.odb.model.OdbRequest;
import software.amazon.awssdk.services.odb.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateOdbNetworkRequest
extends OdbRequest
implements ToCopyableBuilder<Builder, UpdateOdbNetworkRequest> {
    private static final SdkField<String> ODB_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("odbNetworkId").getter(UpdateOdbNetworkRequest.getter(UpdateOdbNetworkRequest::odbNetworkId)).setter(UpdateOdbNetworkRequest.setter(Builder::odbNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("odbNetworkId").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(UpdateOdbNetworkRequest.getter(UpdateOdbNetworkRequest::displayName)).setter(UpdateOdbNetworkRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<List<String>> PEERED_CIDRS_TO_BE_ADDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("peeredCidrsToBeAdded").getter(UpdateOdbNetworkRequest.getter(UpdateOdbNetworkRequest::peeredCidrsToBeAdded)).setter(UpdateOdbNetworkRequest.setter(Builder::peeredCidrsToBeAdded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("peeredCidrsToBeAdded").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PEERED_CIDRS_TO_BE_REMOVED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("peeredCidrsToBeRemoved").getter(UpdateOdbNetworkRequest.getter(UpdateOdbNetworkRequest::peeredCidrsToBeRemoved)).setter(UpdateOdbNetworkRequest.setter(Builder::peeredCidrsToBeRemoved)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("peeredCidrsToBeRemoved").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> S3_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3Access").getter(UpdateOdbNetworkRequest.getter(UpdateOdbNetworkRequest::s3AccessAsString)).setter(UpdateOdbNetworkRequest.setter(Builder::s3Access)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Access").build()}).build();
    private static final SdkField<String> ZERO_ETL_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("zeroEtlAccess").getter(UpdateOdbNetworkRequest.getter(UpdateOdbNetworkRequest::zeroEtlAccessAsString)).setter(UpdateOdbNetworkRequest.setter(Builder::zeroEtlAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zeroEtlAccess").build()}).build();
    private static final SdkField<String> S3_POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3PolicyDocument").getter(UpdateOdbNetworkRequest.getter(UpdateOdbNetworkRequest::s3PolicyDocument)).setter(UpdateOdbNetworkRequest.setter(Builder::s3PolicyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3PolicyDocument").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ODB_NETWORK_ID_FIELD, DISPLAY_NAME_FIELD, PEERED_CIDRS_TO_BE_ADDED_FIELD, PEERED_CIDRS_TO_BE_REMOVED_FIELD, S3_ACCESS_FIELD, ZERO_ETL_ACCESS_FIELD, S3_POLICY_DOCUMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateOdbNetworkRequest.memberNameToFieldInitializer();
    private final String odbNetworkId;
    private final String displayName;
    private final List<String> peeredCidrsToBeAdded;
    private final List<String> peeredCidrsToBeRemoved;
    private final String s3Access;
    private final String zeroEtlAccess;
    private final String s3PolicyDocument;

    private UpdateOdbNetworkRequest(BuilderImpl builder) {
        super(builder);
        this.odbNetworkId = builder.odbNetworkId;
        this.displayName = builder.displayName;
        this.peeredCidrsToBeAdded = builder.peeredCidrsToBeAdded;
        this.peeredCidrsToBeRemoved = builder.peeredCidrsToBeRemoved;
        this.s3Access = builder.s3Access;
        this.zeroEtlAccess = builder.zeroEtlAccess;
        this.s3PolicyDocument = builder.s3PolicyDocument;
    }

    public final String odbNetworkId() {
        return this.odbNetworkId;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final boolean hasPeeredCidrsToBeAdded() {
        return this.peeredCidrsToBeAdded != null && !(this.peeredCidrsToBeAdded instanceof SdkAutoConstructList);
    }

    public final List<String> peeredCidrsToBeAdded() {
        return this.peeredCidrsToBeAdded;
    }

    public final boolean hasPeeredCidrsToBeRemoved() {
        return this.peeredCidrsToBeRemoved != null && !(this.peeredCidrsToBeRemoved instanceof SdkAutoConstructList);
    }

    public final List<String> peeredCidrsToBeRemoved() {
        return this.peeredCidrsToBeRemoved;
    }

    public final Access s3Access() {
        return Access.fromValue(this.s3Access);
    }

    public final String s3AccessAsString() {
        return this.s3Access;
    }

    public final Access zeroEtlAccess() {
        return Access.fromValue(this.zeroEtlAccess);
    }

    public final String zeroEtlAccessAsString() {
        return this.zeroEtlAccess;
    }

    public final String s3PolicyDocument() {
        return this.s3PolicyDocument;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.odbNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPeeredCidrsToBeAdded() ? this.peeredCidrsToBeAdded() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPeeredCidrsToBeRemoved() ? this.peeredCidrsToBeRemoved() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.s3AccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.zeroEtlAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3PolicyDocument());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOdbNetworkRequest)) {
            return false;
        }
        UpdateOdbNetworkRequest other = (UpdateOdbNetworkRequest)((Object)obj);
        return Objects.equals(this.odbNetworkId(), other.odbNetworkId()) && Objects.equals(this.displayName(), other.displayName()) && this.hasPeeredCidrsToBeAdded() == other.hasPeeredCidrsToBeAdded() && Objects.equals(this.peeredCidrsToBeAdded(), other.peeredCidrsToBeAdded()) && this.hasPeeredCidrsToBeRemoved() == other.hasPeeredCidrsToBeRemoved() && Objects.equals(this.peeredCidrsToBeRemoved(), other.peeredCidrsToBeRemoved()) && Objects.equals(this.s3AccessAsString(), other.s3AccessAsString()) && Objects.equals(this.zeroEtlAccessAsString(), other.zeroEtlAccessAsString()) && Objects.equals(this.s3PolicyDocument(), other.s3PolicyDocument());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateOdbNetworkRequest").add("OdbNetworkId", (Object)this.odbNetworkId()).add("DisplayName", (Object)this.displayName()).add("PeeredCidrsToBeAdded", this.hasPeeredCidrsToBeAdded() ? this.peeredCidrsToBeAdded() : null).add("PeeredCidrsToBeRemoved", this.hasPeeredCidrsToBeRemoved() ? this.peeredCidrsToBeRemoved() : null).add("S3Access", (Object)this.s3AccessAsString()).add("ZeroEtlAccess", (Object)this.zeroEtlAccessAsString()).add("S3PolicyDocument", (Object)this.s3PolicyDocument()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "odbNetworkId": {
                return Optional.ofNullable(clazz.cast(this.odbNetworkId()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "peeredCidrsToBeAdded": {
                return Optional.ofNullable(clazz.cast(this.peeredCidrsToBeAdded()));
            }
            case "peeredCidrsToBeRemoved": {
                return Optional.ofNullable(clazz.cast(this.peeredCidrsToBeRemoved()));
            }
            case "s3Access": {
                return Optional.ofNullable(clazz.cast(this.s3AccessAsString()));
            }
            case "zeroEtlAccess": {
                return Optional.ofNullable(clazz.cast(this.zeroEtlAccessAsString()));
            }
            case "s3PolicyDocument": {
                return Optional.ofNullable(clazz.cast(this.s3PolicyDocument()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("odbNetworkId", ODB_NETWORK_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("peeredCidrsToBeAdded", PEERED_CIDRS_TO_BE_ADDED_FIELD);
        map.put("peeredCidrsToBeRemoved", PEERED_CIDRS_TO_BE_REMOVED_FIELD);
        map.put("s3Access", S3_ACCESS_FIELD);
        map.put("zeroEtlAccess", ZERO_ETL_ACCESS_FIELD);
        map.put("s3PolicyDocument", S3_POLICY_DOCUMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateOdbNetworkRequest, T> g) {
        return obj -> g.apply((UpdateOdbNetworkRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OdbRequest.BuilderImpl
    implements Builder {
        private String odbNetworkId;
        private String displayName;
        private List<String> peeredCidrsToBeAdded = DefaultSdkAutoConstructList.getInstance();
        private List<String> peeredCidrsToBeRemoved = DefaultSdkAutoConstructList.getInstance();
        private String s3Access;
        private String zeroEtlAccess;
        private String s3PolicyDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOdbNetworkRequest model) {
            super(model);
            this.odbNetworkId(model.odbNetworkId);
            this.displayName(model.displayName);
            this.peeredCidrsToBeAdded(model.peeredCidrsToBeAdded);
            this.peeredCidrsToBeRemoved(model.peeredCidrsToBeRemoved);
            this.s3Access(model.s3Access);
            this.zeroEtlAccess(model.zeroEtlAccess);
            this.s3PolicyDocument(model.s3PolicyDocument);
        }

        public final String getOdbNetworkId() {
            return this.odbNetworkId;
        }

        public final void setOdbNetworkId(String odbNetworkId) {
            this.odbNetworkId = odbNetworkId;
        }

        @Override
        public final Builder odbNetworkId(String odbNetworkId) {
            this.odbNetworkId = odbNetworkId;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Collection<String> getPeeredCidrsToBeAdded() {
            if (this.peeredCidrsToBeAdded instanceof SdkAutoConstructList) {
                return null;
            }
            return this.peeredCidrsToBeAdded;
        }

        public final void setPeeredCidrsToBeAdded(Collection<String> peeredCidrsToBeAdded) {
            this.peeredCidrsToBeAdded = StringListCopier.copy(peeredCidrsToBeAdded);
        }

        @Override
        public final Builder peeredCidrsToBeAdded(Collection<String> peeredCidrsToBeAdded) {
            this.peeredCidrsToBeAdded = StringListCopier.copy(peeredCidrsToBeAdded);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder peeredCidrsToBeAdded(String ... peeredCidrsToBeAdded) {
            this.peeredCidrsToBeAdded(Arrays.asList(peeredCidrsToBeAdded));
            return this;
        }

        public final Collection<String> getPeeredCidrsToBeRemoved() {
            if (this.peeredCidrsToBeRemoved instanceof SdkAutoConstructList) {
                return null;
            }
            return this.peeredCidrsToBeRemoved;
        }

        public final void setPeeredCidrsToBeRemoved(Collection<String> peeredCidrsToBeRemoved) {
            this.peeredCidrsToBeRemoved = StringListCopier.copy(peeredCidrsToBeRemoved);
        }

        @Override
        public final Builder peeredCidrsToBeRemoved(Collection<String> peeredCidrsToBeRemoved) {
            this.peeredCidrsToBeRemoved = StringListCopier.copy(peeredCidrsToBeRemoved);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder peeredCidrsToBeRemoved(String ... peeredCidrsToBeRemoved) {
            this.peeredCidrsToBeRemoved(Arrays.asList(peeredCidrsToBeRemoved));
            return this;
        }

        public final String getS3Access() {
            return this.s3Access;
        }

        public final void setS3Access(String s3Access) {
            this.s3Access = s3Access;
        }

        @Override
        public final Builder s3Access(String s3Access) {
            this.s3Access = s3Access;
            return this;
        }

        @Override
        public final Builder s3Access(Access s3Access) {
            this.s3Access(s3Access == null ? null : s3Access.toString());
            return this;
        }

        public final String getZeroEtlAccess() {
            return this.zeroEtlAccess;
        }

        public final void setZeroEtlAccess(String zeroEtlAccess) {
            this.zeroEtlAccess = zeroEtlAccess;
        }

        @Override
        public final Builder zeroEtlAccess(String zeroEtlAccess) {
            this.zeroEtlAccess = zeroEtlAccess;
            return this;
        }

        @Override
        public final Builder zeroEtlAccess(Access zeroEtlAccess) {
            this.zeroEtlAccess(zeroEtlAccess == null ? null : zeroEtlAccess.toString());
            return this;
        }

        public final String getS3PolicyDocument() {
            return this.s3PolicyDocument;
        }

        public final void setS3PolicyDocument(String s3PolicyDocument) {
            this.s3PolicyDocument = s3PolicyDocument;
        }

        @Override
        public final Builder s3PolicyDocument(String s3PolicyDocument) {
            this.s3PolicyDocument = s3PolicyDocument;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateOdbNetworkRequest build() {
            return new UpdateOdbNetworkRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OdbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateOdbNetworkRequest> {
        public Builder odbNetworkId(String var1);

        public Builder displayName(String var1);

        public Builder peeredCidrsToBeAdded(Collection<String> var1);

        public Builder peeredCidrsToBeAdded(String ... var1);

        public Builder peeredCidrsToBeRemoved(Collection<String> var1);

        public Builder peeredCidrsToBeRemoved(String ... var1);

        public Builder s3Access(String var1);

        public Builder s3Access(Access var1);

        public Builder zeroEtlAccess(String var1);

        public Builder zeroEtlAccess(Access var1);

        public Builder s3PolicyDocument(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

