/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.odb.model.OdbResponse;
import software.amazon.awssdk.services.odb.model.ResourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCloudAutonomousVmClusterResponse
extends OdbResponse
implements ToCopyableBuilder<Builder, CreateCloudAutonomousVmClusterResponse> {
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(CreateCloudAutonomousVmClusterResponse.getter(CreateCloudAutonomousVmClusterResponse::displayName)).setter(CreateCloudAutonomousVmClusterResponse.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateCloudAutonomousVmClusterResponse.getter(CreateCloudAutonomousVmClusterResponse::statusAsString)).setter(CreateCloudAutonomousVmClusterResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(CreateCloudAutonomousVmClusterResponse.getter(CreateCloudAutonomousVmClusterResponse::statusReason)).setter(CreateCloudAutonomousVmClusterResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<String> CLOUD_AUTONOMOUS_VM_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cloudAutonomousVmClusterId").getter(CreateCloudAutonomousVmClusterResponse.getter(CreateCloudAutonomousVmClusterResponse::cloudAutonomousVmClusterId)).setter(CreateCloudAutonomousVmClusterResponse.setter(Builder::cloudAutonomousVmClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudAutonomousVmClusterId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_NAME_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, CLOUD_AUTONOMOUS_VM_CLUSTER_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateCloudAutonomousVmClusterResponse.memberNameToFieldInitializer();
    private final String displayName;
    private final String status;
    private final String statusReason;
    private final String cloudAutonomousVmClusterId;

    private CreateCloudAutonomousVmClusterResponse(BuilderImpl builder) {
        super(builder);
        this.displayName = builder.displayName;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.cloudAutonomousVmClusterId = builder.cloudAutonomousVmClusterId;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final ResourceStatus status() {
        return ResourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final String cloudAutonomousVmClusterId() {
        return this.cloudAutonomousVmClusterId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudAutonomousVmClusterId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCloudAutonomousVmClusterResponse)) {
            return false;
        }
        CreateCloudAutonomousVmClusterResponse other = (CreateCloudAutonomousVmClusterResponse)((Object)obj);
        return Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.cloudAutonomousVmClusterId(), other.cloudAutonomousVmClusterId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCloudAutonomousVmClusterResponse").add("DisplayName", (Object)this.displayName()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("CloudAutonomousVmClusterId", (Object)this.cloudAutonomousVmClusterId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "cloudAutonomousVmClusterId": {
                return Optional.ofNullable(clazz.cast(this.cloudAutonomousVmClusterId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("cloudAutonomousVmClusterId", CLOUD_AUTONOMOUS_VM_CLUSTER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCloudAutonomousVmClusterResponse, T> g) {
        return obj -> g.apply((CreateCloudAutonomousVmClusterResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OdbResponse.BuilderImpl
    implements Builder {
        private String displayName;
        private String status;
        private String statusReason;
        private String cloudAutonomousVmClusterId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCloudAutonomousVmClusterResponse model) {
            super(model);
            this.displayName(model.displayName);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.cloudAutonomousVmClusterId(model.cloudAutonomousVmClusterId);
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getCloudAutonomousVmClusterId() {
            return this.cloudAutonomousVmClusterId;
        }

        public final void setCloudAutonomousVmClusterId(String cloudAutonomousVmClusterId) {
            this.cloudAutonomousVmClusterId = cloudAutonomousVmClusterId;
        }

        @Override
        public final Builder cloudAutonomousVmClusterId(String cloudAutonomousVmClusterId) {
            this.cloudAutonomousVmClusterId = cloudAutonomousVmClusterId;
            return this;
        }

        @Override
        public CreateCloudAutonomousVmClusterResponse build() {
            return new CreateCloudAutonomousVmClusterResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OdbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCloudAutonomousVmClusterResponse> {
        public Builder displayName(String var1);

        public Builder status(String var1);

        public Builder status(ResourceStatus var1);

        public Builder statusReason(String var1);

        public Builder cloudAutonomousVmClusterId(String var1);
    }
}

