/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.observabilityadmin.model.CloudtrailParameters;
import software.amazon.awssdk.services.observabilityadmin.model.DestinationType;
import software.amazon.awssdk.services.observabilityadmin.model.ELBLoadBalancerLoggingParameters;
import software.amazon.awssdk.services.observabilityadmin.model.LogDeliveryParameters;
import software.amazon.awssdk.services.observabilityadmin.model.VPCFlowLogParameters;
import software.amazon.awssdk.services.observabilityadmin.model.WAFLoggingParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TelemetryDestinationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TelemetryDestinationConfiguration> {
    private static final SdkField<String> DESTINATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationType").getter(TelemetryDestinationConfiguration.getter(TelemetryDestinationConfiguration::destinationTypeAsString)).setter(TelemetryDestinationConfiguration.setter(Builder::destinationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationType").build()}).build();
    private static final SdkField<String> DESTINATION_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationPattern").getter(TelemetryDestinationConfiguration.getter(TelemetryDestinationConfiguration::destinationPattern)).setter(TelemetryDestinationConfiguration.setter(Builder::destinationPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPattern").build()}).build();
    private static final SdkField<Integer> RETENTION_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RetentionInDays").getter(TelemetryDestinationConfiguration.getter(TelemetryDestinationConfiguration::retentionInDays)).setter(TelemetryDestinationConfiguration.setter(Builder::retentionInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionInDays").build()}).build();
    private static final SdkField<VPCFlowLogParameters> VPC_FLOW_LOG_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VPCFlowLogParameters").getter(TelemetryDestinationConfiguration.getter(TelemetryDestinationConfiguration::vpcFlowLogParameters)).setter(TelemetryDestinationConfiguration.setter(Builder::vpcFlowLogParameters)).constructor(VPCFlowLogParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCFlowLogParameters").build()}).build();
    private static final SdkField<CloudtrailParameters> CLOUDTRAIL_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudtrailParameters").getter(TelemetryDestinationConfiguration.getter(TelemetryDestinationConfiguration::cloudtrailParameters)).setter(TelemetryDestinationConfiguration.setter(Builder::cloudtrailParameters)).constructor(CloudtrailParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudtrailParameters").build()}).build();
    private static final SdkField<ELBLoadBalancerLoggingParameters> ELB_LOAD_BALANCER_LOGGING_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ELBLoadBalancerLoggingParameters").getter(TelemetryDestinationConfiguration.getter(TelemetryDestinationConfiguration::elbLoadBalancerLoggingParameters)).setter(TelemetryDestinationConfiguration.setter(Builder::elbLoadBalancerLoggingParameters)).constructor(ELBLoadBalancerLoggingParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ELBLoadBalancerLoggingParameters").build()}).build();
    private static final SdkField<WAFLoggingParameters> WAF_LOGGING_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WAFLoggingParameters").getter(TelemetryDestinationConfiguration.getter(TelemetryDestinationConfiguration::wafLoggingParameters)).setter(TelemetryDestinationConfiguration.setter(Builder::wafLoggingParameters)).constructor(WAFLoggingParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WAFLoggingParameters").build()}).build();
    private static final SdkField<LogDeliveryParameters> LOG_DELIVERY_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LogDeliveryParameters").getter(TelemetryDestinationConfiguration.getter(TelemetryDestinationConfiguration::logDeliveryParameters)).setter(TelemetryDestinationConfiguration.setter(Builder::logDeliveryParameters)).constructor(LogDeliveryParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDeliveryParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_TYPE_FIELD, DESTINATION_PATTERN_FIELD, RETENTION_IN_DAYS_FIELD, VPC_FLOW_LOG_PARAMETERS_FIELD, CLOUDTRAIL_PARAMETERS_FIELD, ELB_LOAD_BALANCER_LOGGING_PARAMETERS_FIELD, WAF_LOGGING_PARAMETERS_FIELD, LOG_DELIVERY_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TelemetryDestinationConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String destinationType;
    private final String destinationPattern;
    private final Integer retentionInDays;
    private final VPCFlowLogParameters vpcFlowLogParameters;
    private final CloudtrailParameters cloudtrailParameters;
    private final ELBLoadBalancerLoggingParameters elbLoadBalancerLoggingParameters;
    private final WAFLoggingParameters wafLoggingParameters;
    private final LogDeliveryParameters logDeliveryParameters;

    private TelemetryDestinationConfiguration(BuilderImpl builder) {
        this.destinationType = builder.destinationType;
        this.destinationPattern = builder.destinationPattern;
        this.retentionInDays = builder.retentionInDays;
        this.vpcFlowLogParameters = builder.vpcFlowLogParameters;
        this.cloudtrailParameters = builder.cloudtrailParameters;
        this.elbLoadBalancerLoggingParameters = builder.elbLoadBalancerLoggingParameters;
        this.wafLoggingParameters = builder.wafLoggingParameters;
        this.logDeliveryParameters = builder.logDeliveryParameters;
    }

    public final DestinationType destinationType() {
        return DestinationType.fromValue(this.destinationType);
    }

    public final String destinationTypeAsString() {
        return this.destinationType;
    }

    public final String destinationPattern() {
        return this.destinationPattern;
    }

    public final Integer retentionInDays() {
        return this.retentionInDays;
    }

    public final VPCFlowLogParameters vpcFlowLogParameters() {
        return this.vpcFlowLogParameters;
    }

    public final CloudtrailParameters cloudtrailParameters() {
        return this.cloudtrailParameters;
    }

    public final ELBLoadBalancerLoggingParameters elbLoadBalancerLoggingParameters() {
        return this.elbLoadBalancerLoggingParameters;
    }

    public final WAFLoggingParameters wafLoggingParameters() {
        return this.wafLoggingParameters;
    }

    public final LogDeliveryParameters logDeliveryParameters() {
        return this.logDeliveryParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcFlowLogParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudtrailParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.elbLoadBalancerLoggingParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.wafLoggingParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.logDeliveryParameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TelemetryDestinationConfiguration)) {
            return false;
        }
        TelemetryDestinationConfiguration other = (TelemetryDestinationConfiguration)obj;
        return Objects.equals(this.destinationTypeAsString(), other.destinationTypeAsString()) && Objects.equals(this.destinationPattern(), other.destinationPattern()) && Objects.equals(this.retentionInDays(), other.retentionInDays()) && Objects.equals(this.vpcFlowLogParameters(), other.vpcFlowLogParameters()) && Objects.equals(this.cloudtrailParameters(), other.cloudtrailParameters()) && Objects.equals(this.elbLoadBalancerLoggingParameters(), other.elbLoadBalancerLoggingParameters()) && Objects.equals(this.wafLoggingParameters(), other.wafLoggingParameters()) && Objects.equals(this.logDeliveryParameters(), other.logDeliveryParameters());
    }

    public final String toString() {
        return ToString.builder((String)"TelemetryDestinationConfiguration").add("DestinationType", (Object)this.destinationTypeAsString()).add("DestinationPattern", (Object)this.destinationPattern()).add("RetentionInDays", (Object)this.retentionInDays()).add("VPCFlowLogParameters", (Object)this.vpcFlowLogParameters()).add("CloudtrailParameters", (Object)this.cloudtrailParameters()).add("ELBLoadBalancerLoggingParameters", (Object)this.elbLoadBalancerLoggingParameters()).add("WAFLoggingParameters", (Object)this.wafLoggingParameters()).add("LogDeliveryParameters", (Object)this.logDeliveryParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationType": {
                return Optional.ofNullable(clazz.cast(this.destinationTypeAsString()));
            }
            case "DestinationPattern": {
                return Optional.ofNullable(clazz.cast(this.destinationPattern()));
            }
            case "RetentionInDays": {
                return Optional.ofNullable(clazz.cast(this.retentionInDays()));
            }
            case "VPCFlowLogParameters": {
                return Optional.ofNullable(clazz.cast(this.vpcFlowLogParameters()));
            }
            case "CloudtrailParameters": {
                return Optional.ofNullable(clazz.cast(this.cloudtrailParameters()));
            }
            case "ELBLoadBalancerLoggingParameters": {
                return Optional.ofNullable(clazz.cast(this.elbLoadBalancerLoggingParameters()));
            }
            case "WAFLoggingParameters": {
                return Optional.ofNullable(clazz.cast(this.wafLoggingParameters()));
            }
            case "LogDeliveryParameters": {
                return Optional.ofNullable(clazz.cast(this.logDeliveryParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DestinationType", DESTINATION_TYPE_FIELD);
        map.put("DestinationPattern", DESTINATION_PATTERN_FIELD);
        map.put("RetentionInDays", RETENTION_IN_DAYS_FIELD);
        map.put("VPCFlowLogParameters", VPC_FLOW_LOG_PARAMETERS_FIELD);
        map.put("CloudtrailParameters", CLOUDTRAIL_PARAMETERS_FIELD);
        map.put("ELBLoadBalancerLoggingParameters", ELB_LOAD_BALANCER_LOGGING_PARAMETERS_FIELD);
        map.put("WAFLoggingParameters", WAF_LOGGING_PARAMETERS_FIELD);
        map.put("LogDeliveryParameters", LOG_DELIVERY_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TelemetryDestinationConfiguration, T> g) {
        return obj -> g.apply((TelemetryDestinationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationType;
        private String destinationPattern;
        private Integer retentionInDays;
        private VPCFlowLogParameters vpcFlowLogParameters;
        private CloudtrailParameters cloudtrailParameters;
        private ELBLoadBalancerLoggingParameters elbLoadBalancerLoggingParameters;
        private WAFLoggingParameters wafLoggingParameters;
        private LogDeliveryParameters logDeliveryParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(TelemetryDestinationConfiguration model) {
            this.destinationType(model.destinationType);
            this.destinationPattern(model.destinationPattern);
            this.retentionInDays(model.retentionInDays);
            this.vpcFlowLogParameters(model.vpcFlowLogParameters);
            this.cloudtrailParameters(model.cloudtrailParameters);
            this.elbLoadBalancerLoggingParameters(model.elbLoadBalancerLoggingParameters);
            this.wafLoggingParameters(model.wafLoggingParameters);
            this.logDeliveryParameters(model.logDeliveryParameters);
        }

        public final String getDestinationType() {
            return this.destinationType;
        }

        public final void setDestinationType(String destinationType) {
            this.destinationType = destinationType;
        }

        @Override
        public final Builder destinationType(String destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        @Override
        public final Builder destinationType(DestinationType destinationType) {
            this.destinationType(destinationType == null ? null : destinationType.toString());
            return this;
        }

        public final String getDestinationPattern() {
            return this.destinationPattern;
        }

        public final void setDestinationPattern(String destinationPattern) {
            this.destinationPattern = destinationPattern;
        }

        @Override
        public final Builder destinationPattern(String destinationPattern) {
            this.destinationPattern = destinationPattern;
            return this;
        }

        public final Integer getRetentionInDays() {
            return this.retentionInDays;
        }

        public final void setRetentionInDays(Integer retentionInDays) {
            this.retentionInDays = retentionInDays;
        }

        @Override
        public final Builder retentionInDays(Integer retentionInDays) {
            this.retentionInDays = retentionInDays;
            return this;
        }

        public final VPCFlowLogParameters.Builder getVpcFlowLogParameters() {
            return this.vpcFlowLogParameters != null ? this.vpcFlowLogParameters.toBuilder() : null;
        }

        public final void setVpcFlowLogParameters(VPCFlowLogParameters.BuilderImpl vpcFlowLogParameters) {
            this.vpcFlowLogParameters = vpcFlowLogParameters != null ? vpcFlowLogParameters.build() : null;
        }

        @Override
        public final Builder vpcFlowLogParameters(VPCFlowLogParameters vpcFlowLogParameters) {
            this.vpcFlowLogParameters = vpcFlowLogParameters;
            return this;
        }

        public final CloudtrailParameters.Builder getCloudtrailParameters() {
            return this.cloudtrailParameters != null ? this.cloudtrailParameters.toBuilder() : null;
        }

        public final void setCloudtrailParameters(CloudtrailParameters.BuilderImpl cloudtrailParameters) {
            this.cloudtrailParameters = cloudtrailParameters != null ? cloudtrailParameters.build() : null;
        }

        @Override
        public final Builder cloudtrailParameters(CloudtrailParameters cloudtrailParameters) {
            this.cloudtrailParameters = cloudtrailParameters;
            return this;
        }

        public final ELBLoadBalancerLoggingParameters.Builder getElbLoadBalancerLoggingParameters() {
            return this.elbLoadBalancerLoggingParameters != null ? this.elbLoadBalancerLoggingParameters.toBuilder() : null;
        }

        public final void setElbLoadBalancerLoggingParameters(ELBLoadBalancerLoggingParameters.BuilderImpl elbLoadBalancerLoggingParameters) {
            this.elbLoadBalancerLoggingParameters = elbLoadBalancerLoggingParameters != null ? elbLoadBalancerLoggingParameters.build() : null;
        }

        @Override
        public final Builder elbLoadBalancerLoggingParameters(ELBLoadBalancerLoggingParameters elbLoadBalancerLoggingParameters) {
            this.elbLoadBalancerLoggingParameters = elbLoadBalancerLoggingParameters;
            return this;
        }

        public final WAFLoggingParameters.Builder getWafLoggingParameters() {
            return this.wafLoggingParameters != null ? this.wafLoggingParameters.toBuilder() : null;
        }

        public final void setWafLoggingParameters(WAFLoggingParameters.BuilderImpl wafLoggingParameters) {
            this.wafLoggingParameters = wafLoggingParameters != null ? wafLoggingParameters.build() : null;
        }

        @Override
        public final Builder wafLoggingParameters(WAFLoggingParameters wafLoggingParameters) {
            this.wafLoggingParameters = wafLoggingParameters;
            return this;
        }

        public final LogDeliveryParameters.Builder getLogDeliveryParameters() {
            return this.logDeliveryParameters != null ? this.logDeliveryParameters.toBuilder() : null;
        }

        public final void setLogDeliveryParameters(LogDeliveryParameters.BuilderImpl logDeliveryParameters) {
            this.logDeliveryParameters = logDeliveryParameters != null ? logDeliveryParameters.build() : null;
        }

        @Override
        public final Builder logDeliveryParameters(LogDeliveryParameters logDeliveryParameters) {
            this.logDeliveryParameters = logDeliveryParameters;
            return this;
        }

        public TelemetryDestinationConfiguration build() {
            return new TelemetryDestinationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TelemetryDestinationConfiguration> {
        public Builder destinationType(String var1);

        public Builder destinationType(DestinationType var1);

        public Builder destinationPattern(String var1);

        public Builder retentionInDays(Integer var1);

        public Builder vpcFlowLogParameters(VPCFlowLogParameters var1);

        default public Builder vpcFlowLogParameters(Consumer<VPCFlowLogParameters.Builder> vpcFlowLogParameters) {
            return this.vpcFlowLogParameters((VPCFlowLogParameters)((VPCFlowLogParameters.Builder)VPCFlowLogParameters.builder().applyMutation(vpcFlowLogParameters)).build());
        }

        public Builder cloudtrailParameters(CloudtrailParameters var1);

        default public Builder cloudtrailParameters(Consumer<CloudtrailParameters.Builder> cloudtrailParameters) {
            return this.cloudtrailParameters((CloudtrailParameters)((CloudtrailParameters.Builder)CloudtrailParameters.builder().applyMutation(cloudtrailParameters)).build());
        }

        public Builder elbLoadBalancerLoggingParameters(ELBLoadBalancerLoggingParameters var1);

        default public Builder elbLoadBalancerLoggingParameters(Consumer<ELBLoadBalancerLoggingParameters.Builder> elbLoadBalancerLoggingParameters) {
            return this.elbLoadBalancerLoggingParameters((ELBLoadBalancerLoggingParameters)((ELBLoadBalancerLoggingParameters.Builder)ELBLoadBalancerLoggingParameters.builder().applyMutation(elbLoadBalancerLoggingParameters)).build());
        }

        public Builder wafLoggingParameters(WAFLoggingParameters var1);

        default public Builder wafLoggingParameters(Consumer<WAFLoggingParameters.Builder> wafLoggingParameters) {
            return this.wafLoggingParameters((WAFLoggingParameters)((WAFLoggingParameters.Builder)WAFLoggingParameters.builder().applyMutation(wafLoggingParameters)).build());
        }

        public Builder logDeliveryParameters(LogDeliveryParameters var1);

        default public Builder logDeliveryParameters(Consumer<LogDeliveryParameters.Builder> logDeliveryParameters) {
            return this.logDeliveryParameters((LogDeliveryParameters)((LogDeliveryParameters.Builder)LogDeliveryParameters.builder().applyMutation(logDeliveryParameters)).build());
        }
    }
}

