/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.observabilityadmin.ObservabilityAdminClient;
import software.amazon.awssdk.services.observabilityadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryRulesForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryRulesForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.TelemetryRuleSummary;

public class ListTelemetryRulesForOrganizationIterable
implements SdkIterable<ListTelemetryRulesForOrganizationResponse> {
    private final ObservabilityAdminClient client;
    private final ListTelemetryRulesForOrganizationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTelemetryRulesForOrganizationIterable(ObservabilityAdminClient client, ListTelemetryRulesForOrganizationRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTelemetryRulesForOrganizationResponseFetcher();
    }

    public Iterator<ListTelemetryRulesForOrganizationResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TelemetryRuleSummary> telemetryRuleSummaries() {
        Function<ListTelemetryRulesForOrganizationResponse, Iterator> getIterator = response -> {
            if (response != null && response.telemetryRuleSummaries() != null) {
                return response.telemetryRuleSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTelemetryRulesForOrganizationResponseFetcher
    implements SyncPageFetcher<ListTelemetryRulesForOrganizationResponse> {
        private ListTelemetryRulesForOrganizationResponseFetcher() {
        }

        public boolean hasNextPage(ListTelemetryRulesForOrganizationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTelemetryRulesForOrganizationResponse nextPage(ListTelemetryRulesForOrganizationResponse previousPage) {
            if (previousPage == null) {
                return ListTelemetryRulesForOrganizationIterable.this.client.listTelemetryRulesForOrganization(ListTelemetryRulesForOrganizationIterable.this.firstRequest);
            }
            return ListTelemetryRulesForOrganizationIterable.this.client.listTelemetryRulesForOrganization((ListTelemetryRulesForOrganizationRequest)((Object)ListTelemetryRulesForOrganizationIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

