/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.observabilityadmin.ObservabilityAdminClient;
import software.amazon.awssdk.services.observabilityadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.observabilityadmin.model.IntegrationSummary;
import software.amazon.awssdk.services.observabilityadmin.model.ListS3TableIntegrationsRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ListS3TableIntegrationsResponse;

public class ListS3TableIntegrationsIterable
implements SdkIterable<ListS3TableIntegrationsResponse> {
    private final ObservabilityAdminClient client;
    private final ListS3TableIntegrationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListS3TableIntegrationsIterable(ObservabilityAdminClient client, ListS3TableIntegrationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListS3TableIntegrationsResponseFetcher();
    }

    public Iterator<ListS3TableIntegrationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IntegrationSummary> integrationSummaries() {
        Function<ListS3TableIntegrationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.integrationSummaries() != null) {
                return response.integrationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListS3TableIntegrationsResponseFetcher
    implements SyncPageFetcher<ListS3TableIntegrationsResponse> {
        private ListS3TableIntegrationsResponseFetcher() {
        }

        public boolean hasNextPage(ListS3TableIntegrationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListS3TableIntegrationsResponse nextPage(ListS3TableIntegrationsResponse previousPage) {
            if (previousPage == null) {
                return ListS3TableIntegrationsIterable.this.client.listS3TableIntegrations(ListS3TableIntegrationsIterable.this.firstRequest);
            }
            return ListS3TableIntegrationsIterable.this.client.listS3TableIntegrations((ListS3TableIntegrationsRequest)((Object)ListS3TableIntegrationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

