/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TelemetrySourceType {
    VPC_FLOW_LOGS("VPC_FLOW_LOGS"),
    ROUTE53_RESOLVER_QUERY_LOGS("ROUTE53_RESOLVER_QUERY_LOGS"),
    EKS_AUDIT_LOGS("EKS_AUDIT_LOGS"),
    EKS_AUTHENTICATOR_LOGS("EKS_AUTHENTICATOR_LOGS"),
    EKS_CONTROLLER_MANAGER_LOGS("EKS_CONTROLLER_MANAGER_LOGS"),
    EKS_SCHEDULER_LOGS("EKS_SCHEDULER_LOGS"),
    EKS_API_LOGS("EKS_API_LOGS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TelemetrySourceType> VALUE_MAP;
    private final String value;

    private TelemetrySourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TelemetrySourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TelemetrySourceType> knownValues() {
        EnumSet<TelemetrySourceType> knownValues = EnumSet.allOf(TelemetrySourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TelemetrySourceType.class, TelemetrySourceType::toString);
    }
}

