/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.observabilityadmin.model.TagMapOutputCopier;
import software.amazon.awssdk.services.observabilityadmin.model.TelemetryPipelineConfiguration;
import software.amazon.awssdk.services.observabilityadmin.model.TelemetryPipelineStatus;
import software.amazon.awssdk.services.observabilityadmin.model.TelemetryPipelineStatusReason;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TelemetryPipeline
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TelemetryPipeline> {
    private static final SdkField<Long> CREATED_TIME_STAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CreatedTimeStamp").getter(TelemetryPipeline.getter(TelemetryPipeline::createdTimeStamp)).setter(TelemetryPipeline.setter(Builder::createdTimeStamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimeStamp").build()}).build();
    private static final SdkField<Long> LAST_UPDATE_TIME_STAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("LastUpdateTimeStamp").getter(TelemetryPipeline.getter(TelemetryPipeline::lastUpdateTimeStamp)).setter(TelemetryPipeline.setter(Builder::lastUpdateTimeStamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTimeStamp").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(TelemetryPipeline.getter(TelemetryPipeline::arn)).setter(TelemetryPipeline.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(TelemetryPipeline.getter(TelemetryPipeline::name)).setter(TelemetryPipeline.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<TelemetryPipelineConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Configuration").getter(TelemetryPipeline.getter(TelemetryPipeline::configuration)).setter(TelemetryPipeline.setter(Builder::configuration)).constructor(TelemetryPipelineConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(TelemetryPipeline.getter(TelemetryPipeline::statusAsString)).setter(TelemetryPipeline.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<TelemetryPipelineStatusReason> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StatusReason").getter(TelemetryPipeline.getter(TelemetryPipeline::statusReason)).setter(TelemetryPipeline.setter(Builder::statusReason)).constructor(TelemetryPipelineStatusReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(TelemetryPipeline.getter(TelemetryPipeline::tags)).setter(TelemetryPipeline.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_TIME_STAMP_FIELD, LAST_UPDATE_TIME_STAMP_FIELD, ARN_FIELD, NAME_FIELD, CONFIGURATION_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TelemetryPipeline.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long createdTimeStamp;
    private final Long lastUpdateTimeStamp;
    private final String arn;
    private final String name;
    private final TelemetryPipelineConfiguration configuration;
    private final String status;
    private final TelemetryPipelineStatusReason statusReason;
    private final Map<String, String> tags;

    private TelemetryPipeline(BuilderImpl builder) {
        this.createdTimeStamp = builder.createdTimeStamp;
        this.lastUpdateTimeStamp = builder.lastUpdateTimeStamp;
        this.arn = builder.arn;
        this.name = builder.name;
        this.configuration = builder.configuration;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.tags = builder.tags;
    }

    public final Long createdTimeStamp() {
        return this.createdTimeStamp;
    }

    public final Long lastUpdateTimeStamp() {
        return this.lastUpdateTimeStamp;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final TelemetryPipelineConfiguration configuration() {
        return this.configuration;
    }

    public final TelemetryPipelineStatus status() {
        return TelemetryPipelineStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final TelemetryPipelineStatusReason statusReason() {
        return this.statusReason;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TelemetryPipeline)) {
            return false;
        }
        TelemetryPipeline other = (TelemetryPipeline)obj;
        return Objects.equals(this.createdTimeStamp(), other.createdTimeStamp()) && Objects.equals(this.lastUpdateTimeStamp(), other.lastUpdateTimeStamp()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"TelemetryPipeline").add("CreatedTimeStamp", (Object)this.createdTimeStamp()).add("LastUpdateTimeStamp", (Object)this.lastUpdateTimeStamp()).add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Configuration", (Object)this.configuration()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedTimeStamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimeStamp()));
            }
            case "LastUpdateTimeStamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTimeStamp()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CreatedTimeStamp", CREATED_TIME_STAMP_FIELD);
        map.put("LastUpdateTimeStamp", LAST_UPDATE_TIME_STAMP_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Configuration", CONFIGURATION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TelemetryPipeline, T> g) {
        return obj -> g.apply((TelemetryPipeline)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long createdTimeStamp;
        private Long lastUpdateTimeStamp;
        private String arn;
        private String name;
        private TelemetryPipelineConfiguration configuration;
        private String status;
        private TelemetryPipelineStatusReason statusReason;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TelemetryPipeline model) {
            this.createdTimeStamp(model.createdTimeStamp);
            this.lastUpdateTimeStamp(model.lastUpdateTimeStamp);
            this.arn(model.arn);
            this.name(model.name);
            this.configuration(model.configuration);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.tags(model.tags);
        }

        public final Long getCreatedTimeStamp() {
            return this.createdTimeStamp;
        }

        public final void setCreatedTimeStamp(Long createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
        }

        @Override
        public final Builder createdTimeStamp(Long createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
            return this;
        }

        public final Long getLastUpdateTimeStamp() {
            return this.lastUpdateTimeStamp;
        }

        public final void setLastUpdateTimeStamp(Long lastUpdateTimeStamp) {
            this.lastUpdateTimeStamp = lastUpdateTimeStamp;
        }

        @Override
        public final Builder lastUpdateTimeStamp(Long lastUpdateTimeStamp) {
            this.lastUpdateTimeStamp = lastUpdateTimeStamp;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final TelemetryPipelineConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(TelemetryPipelineConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(TelemetryPipelineConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TelemetryPipelineStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final TelemetryPipelineStatusReason.Builder getStatusReason() {
            return this.statusReason != null ? this.statusReason.toBuilder() : null;
        }

        public final void setStatusReason(TelemetryPipelineStatusReason.BuilderImpl statusReason) {
            this.statusReason = statusReason != null ? statusReason.build() : null;
        }

        @Override
        public final Builder statusReason(TelemetryPipelineStatusReason statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapOutputCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapOutputCopier.copy(tags);
            return this;
        }

        public TelemetryPipeline build() {
            return new TelemetryPipeline(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TelemetryPipeline> {
        public Builder createdTimeStamp(Long var1);

        public Builder lastUpdateTimeStamp(Long var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder configuration(TelemetryPipelineConfiguration var1);

        default public Builder configuration(Consumer<TelemetryPipelineConfiguration.Builder> configuration) {
            return this.configuration((TelemetryPipelineConfiguration)((TelemetryPipelineConfiguration.Builder)TelemetryPipelineConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder status(String var1);

        public Builder status(TelemetryPipelineStatus var1);

        public Builder statusReason(TelemetryPipelineStatusReason var1);

        default public Builder statusReason(Consumer<TelemetryPipelineStatusReason.Builder> statusReason) {
            return this.statusReason((TelemetryPipelineStatusReason)((TelemetryPipelineStatusReason.Builder)TelemetryPipelineStatusReason.builder().applyMutation(statusReason)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

