/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.observabilityadmin.ObservabilityAdminClient;
import software.amazon.awssdk.services.observabilityadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryRulesRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryRulesResponse;
import software.amazon.awssdk.services.observabilityadmin.model.TelemetryRuleSummary;

public class ListTelemetryRulesIterable
implements SdkIterable<ListTelemetryRulesResponse> {
    private final ObservabilityAdminClient client;
    private final ListTelemetryRulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTelemetryRulesIterable(ObservabilityAdminClient client, ListTelemetryRulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTelemetryRulesResponseFetcher();
    }

    public Iterator<ListTelemetryRulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TelemetryRuleSummary> telemetryRuleSummaries() {
        Function<ListTelemetryRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.telemetryRuleSummaries() != null) {
                return response.telemetryRuleSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTelemetryRulesResponseFetcher
    implements SyncPageFetcher<ListTelemetryRulesResponse> {
        private ListTelemetryRulesResponseFetcher() {
        }

        public boolean hasNextPage(ListTelemetryRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTelemetryRulesResponse nextPage(ListTelemetryRulesResponse previousPage) {
            if (previousPage == null) {
                return ListTelemetryRulesIterable.this.client.listTelemetryRules(ListTelemetryRulesIterable.this.firstRequest);
            }
            return ListTelemetryRulesIterable.this.client.listTelemetryRules((ListTelemetryRulesRequest)((Object)ListTelemetryRulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

